/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.system.domain.Dept;
import me.zhengjie.modules.system.domain.User;
import me.zhengjie.modules.system.repository.DeptRepository;
import me.zhengjie.modules.system.repository.RoleRepository;
import me.zhengjie.modules.system.repository.UserRepository;
import me.zhengjie.modules.system.service.DeptService;
import me.zhengjie.modules.system.service.dto.DeptDto;
import me.zhengjie.modules.system.service.dto.DeptQueryCriteria;
import me.zhengjie.modules.system.service.impl.DeptServiceImpl;
import me.zhengjie.modules.system.service.mapstruct.DeptMapper;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.SecurityUtils;
import me.zhengjie.utils.StringUtils;
import me.zhengjie.utils.ValidationUtil;
import me.zhengjie.utils.enums.DataScopeEnum;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@CacheConfig(cacheNames={"dept"})
public class DeptServiceImpl
implements DeptService {
    private final DeptRepository deptRepository;
    private final DeptMapper deptMapper;
    private final UserRepository userRepository;
    private final RedisUtils redisUtils;
    private final RoleRepository roleRepository;

    public List<DeptDto> queryAll(DeptQueryCriteria criteria, Boolean isQuery) throws Exception {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"deptSort"});
        String dataScopeType = SecurityUtils.getDataScopeType();
        if (isQuery.booleanValue()) {
            if (dataScopeType.equals(DataScopeEnum.ALL.getValue())) {
                criteria.setPidIsNull(Boolean.valueOf(true));
            }
            List fields = QueryHelp.getAllFields(criteria.getClass(), new ArrayList());
            1 fieldNames = new /* Unavailable Anonymous Inner Class!! */;
            for (Field field : fields) {
                field.setAccessible(true);
                Object val = field.get(criteria);
                if (fieldNames.contains(field.getName()) || !ObjectUtil.isNotNull((Object)val)) continue;
                criteria.setPidIsNull(null);
                break;
            }
        }
        List list = this.deptMapper.toDto(this.deptRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), sort));
        if (StringUtils.isBlank((CharSequence)dataScopeType)) {
            return this.deduplication(list);
        }
        return list;
    }

    @Cacheable(key="'id:' + #p0")
    public DeptDto findById(Long id) {
        Dept dept = this.deptRepository.findById((Object)id).orElseGet(Dept::new);
        ValidationUtil.isNull((Object)dept.getId(), (String)"Dept", (String)"id", (Object)id);
        return (DeptDto)this.deptMapper.toDto((Object)dept);
    }

    public List<Dept> findByPid(long pid) {
        return this.deptRepository.findByPid(Long.valueOf(pid));
    }

    public Set<Dept> findByRoleId(Long id) {
        return this.deptRepository.findByRoleId(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(Dept resources) {
        this.deptRepository.save((Object)resources);
        resources.setSubCount(Integer.valueOf(0));
        this.updateSubCnt(resources.getPid());
        this.delCaches(resources.getPid());
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(Dept resources) {
        Long oldPid = this.findById(resources.getId()).getPid();
        Long newPid = resources.getPid();
        if (resources.getPid() != null && resources.getId().equals(resources.getPid())) {
            throw new BadRequestException("\u4e0a\u7ea7\u4e0d\u80fd\u4e3a\u81ea\u5df1");
        }
        Dept dept = this.deptRepository.findById((Object)resources.getId()).orElseGet(Dept::new);
        ValidationUtil.isNull((Object)dept.getId(), (String)"Dept", (String)"id", (Object)resources.getId());
        resources.setId(dept.getId());
        this.deptRepository.save((Object)resources);
        this.updateSubCnt(oldPid);
        this.updateSubCnt(newPid);
        this.delCaches(resources.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<DeptDto> deptDtos) {
        for (DeptDto deptDto : deptDtos) {
            this.delCaches(deptDto.getId());
            this.deptRepository.deleteById((Object)deptDto.getId());
            this.updateSubCnt(deptDto.getPid());
        }
    }

    public void download(List<DeptDto> deptDtos, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (DeptDto deptDTO : deptDtos) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u90e8\u95e8\u540d\u79f0", deptDTO.getName());
            map.put("\u90e8\u95e8\u72b6\u6001", deptDTO.getEnabled() != false ? "\u542f\u7528" : "\u505c\u7528");
            map.put("\u521b\u5efa\u65e5\u671f", deptDTO.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public Set<DeptDto> getDeleteDepts(List<Dept> menuList, Set<DeptDto> deptDtos) {
        for (Dept dept : menuList) {
            deptDtos.add((DeptDto)this.deptMapper.toDto((Object)dept));
            List depts = this.deptRepository.findByPid(dept.getId());
            if (depts == null || depts.size() == 0) continue;
            this.getDeleteDepts(depts, deptDtos);
        }
        return deptDtos;
    }

    public List<Long> getDeptChildren(List<Dept> deptList) {
        ArrayList<Long> list = new ArrayList<Long>();
        deptList.forEach(dept -> {
            if (dept != null && dept.getEnabled().booleanValue()) {
                List depts = this.deptRepository.findByPid(dept.getId());
                if (depts.size() != 0) {
                    list.addAll(this.getDeptChildren(depts));
                }
                list.add(dept.getId());
            }
        });
        return list;
    }

    public List<DeptDto> getSuperior(DeptDto deptDto, List<Dept> depts) {
        if (deptDto.getPid() == null) {
            depts.addAll(this.deptRepository.findByPidIsNull());
            return this.deptMapper.toDto(depts);
        }
        depts.addAll(this.deptRepository.findByPid(deptDto.getPid()));
        return this.getSuperior(this.findById(deptDto.getPid()), depts);
    }

    public Object buildTree(List<DeptDto> deptDtos) {
        LinkedHashSet<DeptDto> trees = new LinkedHashSet<DeptDto>();
        LinkedHashSet<DeptDto> depts = new LinkedHashSet<DeptDto>();
        List deptNames = deptDtos.stream().map(DeptDto::getName).collect(Collectors.toList());
        for (DeptDto deptDTO : deptDtos) {
            boolean isChild = false;
            if (deptDTO.getPid() == null) {
                trees.add(deptDTO);
            }
            for (DeptDto it : deptDtos) {
                if (it.getPid() == null || !deptDTO.getId().equals(it.getPid())) continue;
                isChild = true;
                if (deptDTO.getChildren() == null) {
                    deptDTO.setChildren(new ArrayList());
                }
                deptDTO.getChildren().add(it);
            }
            if (isChild) {
                depts.add(deptDTO);
                continue;
            }
            if (deptDTO.getPid() == null || deptNames.contains(this.findById(deptDTO.getPid()).getName())) continue;
            depts.add(deptDTO);
        }
        if (CollectionUtil.isEmpty(trees)) {
            trees = depts;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("totalElements", deptDtos.size());
        map.put("content", CollectionUtil.isEmpty(trees) ? deptDtos : trees);
        return map;
    }

    public void verification(Set<DeptDto> deptDtos) {
        Set deptIds = deptDtos.stream().map(DeptDto::getId).collect(Collectors.toSet());
        if (this.userRepository.countByDepts(deptIds) > 0) {
            throw new BadRequestException("\u6240\u9009\u90e8\u95e8\u5b58\u5728\u7528\u6237\u5173\u8054\uff0c\u8bf7\u89e3\u9664\u540e\u518d\u8bd5\uff01");
        }
        if (this.roleRepository.countByDepts(deptIds) > 0) {
            throw new BadRequestException("\u6240\u9009\u90e8\u95e8\u5b58\u5728\u89d2\u8272\u5173\u8054\uff0c\u8bf7\u89e3\u9664\u540e\u518d\u8bd5\uff01");
        }
    }

    private void updateSubCnt(Long deptId) {
        if (deptId != null) {
            int count = this.deptRepository.countByPid(deptId);
            this.deptRepository.updateSubCntById(Integer.valueOf(count), deptId);
        }
    }

    private List<DeptDto> deduplication(List<DeptDto> list) {
        ArrayList<DeptDto> deptDtos = new ArrayList<DeptDto>();
        for (DeptDto deptDto : list) {
            boolean flag = true;
            for (DeptDto dto : list) {
                if (!dto.getId().equals(deptDto.getPid())) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            deptDtos.add(deptDto);
        }
        return deptDtos;
    }

    public void delCaches(Long id) {
        List users = this.userRepository.findByRoleDeptId(id);
        this.redisUtils.delByKeys("data::user:", users.stream().map(User::getId).collect(Collectors.toSet()));
        this.redisUtils.del(new String[]{"dept::id:" + id});
    }

    public DeptServiceImpl(DeptRepository deptRepository, DeptMapper deptMapper, UserRepository userRepository, RedisUtils redisUtils, RoleRepository roleRepository) {
        this.deptRepository = deptRepository;
        this.deptMapper = deptMapper;
        this.userRepository = userRepository;
        this.redisUtils = redisUtils;
        this.roleRepository = roleRepository;
    }
}

