/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.domain;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import me.zhengjie.base.BaseEntity;
import me.zhengjie.modules.system.domain.Dept;
import me.zhengjie.modules.system.domain.Menu;
import me.zhengjie.modules.system.domain.User;
import me.zhengjie.utils.enums.DataScopeEnum;

@Entity
@Table(name="sys_role")
public class Role
extends BaseEntity
implements Serializable {
    @Id
    @Column(name="role_id")
    @NotNull(groups={BaseEntity.Update.class})
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @ApiModelProperty(value="ID", hidden=true)
    private Long id;
    @JSONField(serialize=false)
    @ManyToMany(mappedBy="roles")
    @ApiModelProperty(value="\u7528\u6237", hidden=true)
    private Set<User> users;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="sys_roles_menus", joinColumns={@JoinColumn(name="role_id", referencedColumnName="role_id")}, inverseJoinColumns={@JoinColumn(name="menu_id", referencedColumnName="menu_id")})
    @ApiModelProperty(value="\u83dc\u5355", hidden=true)
    private Set<Menu> menus;
    @ManyToMany
    @JoinTable(name="sys_roles_depts", joinColumns={@JoinColumn(name="role_id", referencedColumnName="role_id")}, inverseJoinColumns={@JoinColumn(name="dept_id", referencedColumnName="dept_id")})
    @ApiModelProperty(value="\u90e8\u95e8", hidden=true)
    private Set<Dept> depts;
    @NotBlank
    @ApiModelProperty(value="\u540d\u79f0", hidden=true)
    private String name;
    @ApiModelProperty(value="\u6570\u636e\u6743\u9650\uff0c\u5168\u90e8 \u3001 \u672c\u7ea7 \u3001 \u81ea\u5b9a\u4e49")
    private String dataScope = DataScopeEnum.THIS_LEVEL.getValue();
    @Column(name="level")
    @ApiModelProperty(value="\u7ea7\u522b\uff0c\u6570\u503c\u8d8a\u5c0f\uff0c\u7ea7\u522b\u8d8a\u5927")
    private Integer level = 3;
    @ApiModelProperty(value="\u63cf\u8ff0")
    private String description;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return Objects.equals(this.id, role.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Long getId() {
        return this.id;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public Set<Menu> getMenus() {
        return this.menus;
    }

    public Set<Dept> getDepts() {
        return this.depts;
    }

    public String getName() {
        return this.name;
    }

    public String getDataScope() {
        return this.dataScope;
    }

    public Integer getLevel() {
        return this.level;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    public void setMenus(Set<Menu> menus) {
        this.menus = menus;
    }

    public void setDepts(Set<Dept> depts) {
        this.depts = depts;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDataScope(String dataScope) {
        this.dataScope = dataScope;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

