/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.util;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.SCPClient;
import com.google.common.collect.Maps;
import java.util.Map;

public class ScpClientUtil {
    private static Map<String, ScpClientUtil> instance = Maps.newHashMap();
    private String ip;
    private int port;
    private String username;
    private String password;

    public static synchronized ScpClientUtil getInstance(String ip, int port, String username, String password) {
        if (instance.get(ip) == null) {
            instance.put(ip, new ScpClientUtil(ip, port, username, password));
        }
        return (ScpClientUtil)instance.get(ip);
    }

    public ScpClientUtil(String ip, int port, String username, String password) {
        this.ip = ip;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFile(String remoteFile, String localTargetDirectory) {
        try (Connection conn = new Connection(this.ip, this.port);){
            conn.connect();
            boolean isAuthenticated = conn.authenticateWithPassword(this.username, this.password);
            if (!isAuthenticated) {
                System.err.println("authentication failed");
            }
            SCPClient client = new SCPClient(conn);
            client.get(remoteFile, localTargetDirectory);
        }
    }

    public void putFile(String localFile, String remoteTargetDirectory) {
        this.putFile(localFile, null, remoteTargetDirectory);
    }

    public void putFile(String localFile, String remoteFileName, String remoteTargetDirectory) {
        this.putFile(localFile, remoteFileName, remoteTargetDirectory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFile(String localFile, String remoteFileName, String remoteTargetDirectory, String mode) {
        try (Connection conn = new Connection(this.ip, this.port);){
            conn.connect();
            boolean isAuthenticated = conn.authenticateWithPassword(this.username, this.password);
            if (!isAuthenticated) {
                System.err.println("authentication failed");
            }
            SCPClient client = new SCPClient(conn);
            if (mode == null || mode.length() == 0) {
                mode = "0600";
            }
            if (remoteFileName == null) {
                client.put(localFile, remoteTargetDirectory);
            } else {
                client.put(localFile, remoteFileName, remoteTargetDirectory, mode);
            }
        }
    }
}

