/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public enum DataTypeEnum {
    MYSQL("mysql", "mysql", "com.mysql.jdbc.Driver", "`", "`", "'", "'"),
    ORACLE("oracle", "oracle", "oracle.jdbc.driver.OracleDriver", "\"", "\"", "\"", "\""),
    SQLSERVER("sqlserver", "sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "\"", "\"", "\"", "\""),
    H2("h2", "h2", "org.h2.Driver", "`", "`", "\"", "\""),
    PHOENIX("phoenix", "hbase phoenix", "org.apache.phoenix.jdbc.PhoenixDriver", "", "", "\"", "\""),
    MONGODB("mongo", "mongodb", "mongodb.jdbc.MongoDriver", "`", "`", "\"", "\""),
    ELASTICSEARCH("sql4es", "elasticsearch", "nl.anchormen.sql4es.jdbc.ESDriver", "", "", "'", "'"),
    PRESTO("presto", "presto", "com.facebook.presto.jdbc.PrestoDriver", "", "", "\"", "\""),
    MOONBOX("moonbox", "moonbox", "moonbox.jdbc.MbDriver", "`", "`", "`", "`"),
    CASSANDRA("cassandra", "cassandra", "com.github.adejanovski.cassandra.jdbc.CassandraDriver", "", "", "'", "'"),
    CLICKHOUSE("clickhouse", "clickhouse", "ru.yandex.clickhouse.ClickHouseDriver", "", "", "\"", "\""),
    KYLIN("kylin", "kylin", "org.apache.kylin.jdbc.Driver", "\"", "\"", "\"", "\""),
    VERTICA("vertica", "vertica", "com.vertica.jdbc.Driver", "", "", "'", "'"),
    HANA("sap", "sap hana", "com.sap.db.jdbc.Driver", "", "", "'", "'"),
    IMPALA("impala", "impala", "com.cloudera.impala.jdbc41.Driver", "", "", "'", "'");

    private static final Logger log;
    private String feature;
    private String desc;
    private String driver;
    private String keywordPrefix;
    private String keywordSuffix;
    private String aliasPrefix;
    private String aliasSuffix;
    private static final String JDBC_URL_PREFIX = "jdbc:";

    private DataTypeEnum(String feature, String desc, String driver, String keywordPrefix, String keywordSuffix, String aliasPrefix, String aliasSuffix) {
        this.feature = feature;
        this.desc = desc;
        this.driver = driver;
        this.keywordPrefix = keywordPrefix;
        this.keywordSuffix = keywordSuffix;
        this.aliasPrefix = aliasPrefix;
        this.aliasSuffix = aliasSuffix;
    }

    public static DataTypeEnum urlOf(String jdbcUrl) {
        String url = jdbcUrl.toLowerCase().trim();
        for (DataTypeEnum dataTypeEnum : DataTypeEnum.values()) {
            if (!url.startsWith("jdbc:" + dataTypeEnum.feature)) continue;
            try {
                Class<?> aClass = Class.forName(dataTypeEnum.getDriver());
                if (null == aClass) {
                    throw new RuntimeException("Unable to get driver instance for jdbcUrl: " + jdbcUrl);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to get driver instance: " + jdbcUrl);
            }
            return dataTypeEnum;
        }
        return null;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getKeywordPrefix() {
        return this.keywordPrefix;
    }

    public String getKeywordSuffix() {
        return this.keywordSuffix;
    }

    public String getAliasPrefix() {
        return this.aliasPrefix;
    }

    public String getAliasSuffix() {
        return this.aliasSuffix;
    }

    static {
        log = LoggerFactory.getLogger(DataTypeEnum.class);
    }
}

