/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.modules.system.domain.Dict;
import me.zhengjie.modules.system.repository.DictRepository;
import me.zhengjie.modules.system.service.DictService;
import me.zhengjie.modules.system.service.dto.DictDetailDto;
import me.zhengjie.modules.system.service.dto.DictDto;
import me.zhengjie.modules.system.service.dto.DictQueryCriteria;
import me.zhengjie.modules.system.service.mapstruct.DictMapper;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.ValidationUtil;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@CacheConfig(cacheNames={"dict"})
public class DictServiceImpl
implements DictService {
    private final DictRepository dictRepository;
    private final DictMapper dictMapper;
    private final RedisUtils redisUtils;

    public Map<String, Object> queryAll(DictQueryCriteria dict, Pageable pageable) {
        Page page = this.dictRepository.findAll((Specification & Serializable)(root, query, cb) -> QueryHelp.getPredicate((Root)root, (Object)dict, (CriteriaBuilder)cb), pageable);
        return PageUtil.toPage((Page)page.map(arg_0 -> ((DictMapper)this.dictMapper).toDto(arg_0)));
    }

    public List<DictDto> queryAll(DictQueryCriteria dict) {
        List list = this.dictRepository.findAll((Specification & Serializable)(root, query, cb) -> QueryHelp.getPredicate((Root)root, (Object)dict, (CriteriaBuilder)cb));
        return this.dictMapper.toDto(list);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(Dict resources) {
        this.dictRepository.save((Object)resources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(Dict resources) {
        this.delCaches(resources);
        Dict dict = this.dictRepository.findById((Object)resources.getId()).orElseGet(Dict::new);
        ValidationUtil.isNull((Object)dict.getId(), (String)"Dict", (String)"id", (Object)resources.getId());
        dict.setName(resources.getName());
        dict.setDescription(resources.getDescription());
        this.dictRepository.save((Object)dict);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<Long> ids) {
        List dicts = this.dictRepository.findByIdIn(ids);
        for (Dict dict : dicts) {
            this.delCaches(dict);
        }
        this.dictRepository.deleteByIdIn(ids);
    }

    public void download(List<DictDto> dictDtos, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (DictDto dictDTO : dictDtos) {
            if (CollectionUtil.isNotEmpty((Collection)dictDTO.getDictDetails())) {
                for (DictDetailDto dictDetail : dictDTO.getDictDetails()) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    map.put("\u5b57\u5178\u540d\u79f0", dictDTO.getName());
                    map.put("\u5b57\u5178\u63cf\u8ff0", dictDTO.getDescription());
                    map.put("\u5b57\u5178\u6807\u7b7e", dictDetail.getLabel());
                    map.put("\u5b57\u5178\u503c", dictDetail.getValue());
                    map.put("\u521b\u5efa\u65e5\u671f", dictDetail.getCreateTime());
                    list.add(map);
                }
                continue;
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u5b57\u5178\u540d\u79f0", dictDTO.getName());
            map.put("\u5b57\u5178\u63cf\u8ff0", dictDTO.getDescription());
            map.put("\u5b57\u5178\u6807\u7b7e", null);
            map.put("\u5b57\u5178\u503c", null);
            map.put("\u521b\u5efa\u65e5\u671f", dictDTO.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public void delCaches(Dict dict) {
        this.redisUtils.del(new String[]{"dict::name:" + dict.getName()});
    }

    public DictServiceImpl(DictRepository dictRepository, DictMapper dictMapper, RedisUtils redisUtils) {
        this.dictRepository = dictRepository;
        this.dictMapper = dictMapper;
        this.redisUtils = redisUtils;
    }
}

