/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.util;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.util.StringUtils;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import me.zhengjie.modules.mnt.util.DataTypeEnum;
import me.zhengjie.utils.CloseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SqlUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlUtils.class);

    private static DataSource getDataSource(String jdbcUrl, String userName, String password) {
        String className;
        DruidDataSource druidDataSource = new DruidDataSource();
        try {
            className = DriverManager.getDriver(jdbcUrl.trim()).getClass().getName();
        }
        catch (SQLException e) {
            throw new RuntimeException("Get class name error: =" + jdbcUrl);
        }
        if (StringUtils.isEmpty((CharSequence)className)) {
            DataTypeEnum dataTypeEnum = DataTypeEnum.urlOf((String)jdbcUrl);
            if (null == dataTypeEnum) {
                throw new RuntimeException("Not supported data type: jdbcUrl=" + jdbcUrl);
            }
            druidDataSource.setDriverClassName(dataTypeEnum.getDriver());
        } else {
            druidDataSource.setDriverClassName(className);
        }
        druidDataSource.setUrl(jdbcUrl);
        druidDataSource.setUsername(userName);
        druidDataSource.setPassword(password);
        druidDataSource.setMaxWait(3000L);
        druidDataSource.setInitialSize(1);
        druidDataSource.setMinIdle(1);
        druidDataSource.setMaxActive(1);
        druidDataSource.setBreakAfterAcquireFailure(true);
        try {
            druidDataSource.init();
        }
        catch (SQLException e) {
            log.error("Exception during pool initialization", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        return druidDataSource;
    }

    private static Connection getConnection(String jdbcUrl, String userName, String password) {
        DataSource dataSource = SqlUtils.getDataSource((String)jdbcUrl, (String)userName, (String)password);
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int timeOut = 5;
            if (null == connection || connection.isClosed() || !connection.isValid(timeOut)) {
                log.info("connection is closed or invalid, retry get connection!");
                connection = dataSource.getConnection();
            }
        }
        catch (Exception e) {
            log.error("create connection error, jdbcUrl: {}", (Object)jdbcUrl);
            throw new RuntimeException("create connection error, jdbcUrl: " + jdbcUrl);
        }
        finally {
            CloseUtil.close((AutoCloseable)connection);
        }
        return connection;
    }

    private static void releaseConnection(Connection connection) {
        if (null != connection) {
            try {
                connection.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                log.error("connection close error\uff1a" + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testConnection(String jdbcUrl, String userName, String password) {
        Connection connection;
        block4: {
            boolean bl;
            connection = null;
            try {
                connection = SqlUtils.getConnection((String)jdbcUrl, (String)userName, (String)password);
                if (null == connection) break block4;
                bl = true;
            }
            catch (Exception e) {
                try {
                    log.info("Get connection failed:" + e.getMessage());
                }
                catch (Throwable throwable) {
                    SqlUtils.releaseConnection(connection);
                    throw throwable;
                }
                SqlUtils.releaseConnection((Connection)connection);
            }
            SqlUtils.releaseConnection((Connection)connection);
            return bl;
        }
        SqlUtils.releaseConnection((Connection)connection);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeFile(String jdbcUrl, String userName, String password, File sqlFile) {
        Connection connection = SqlUtils.getConnection((String)jdbcUrl, (String)userName, (String)password);
        try {
            SqlUtils.batchExecute((Connection)connection, (List)SqlUtils.readSqlList((File)sqlFile));
        }
        catch (Exception e) {
            log.error("sql\u811a\u672c\u6267\u884c\u53d1\u751f\u5f02\u5e38:{}", (Object)e.getMessage());
            String string = e.getMessage();
            return string;
        }
        finally {
            SqlUtils.releaseConnection((Connection)connection);
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchExecute(Connection connection, List<String> sqlList) {
        Statement st = null;
        try {
            st = connection.createStatement();
            for (String sql : sqlList) {
                if (sql.endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                st.addBatch(sql);
            }
            st.executeBatch();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        finally {
            CloseUtil.close((AutoCloseable)st);
        }
    }

    private static List<String> readSqlList(File sqlFile) throws Exception {
        ArrayList sqlList = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sqlFile), StandardCharsets.UTF_8));){
            String tmp;
            while ((tmp = reader.readLine()) != null) {
                log.info("line:{}", (Object)tmp);
                if (tmp.endsWith(";")) {
                    sb.append(tmp);
                    sqlList.add(sb.toString());
                    sb.delete(0, sb.length());
                    continue;
                }
                sb.append(tmp);
            }
            if (!"".endsWith(sb.toString().trim())) {
                sqlList.add(sb.toString());
            }
        }
        return sqlList;
    }
}

