/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.domain;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import me.zhengjie.base.BaseEntity;
import me.zhengjie.modules.system.domain.Dept;
import me.zhengjie.modules.system.domain.Job;
import me.zhengjie.modules.system.domain.Role;

@Entity
@Table(name="sys_user")
public class User
extends BaseEntity
implements Serializable {
    @Id
    @Column(name="user_id")
    @NotNull(groups={BaseEntity.Update.class})
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @ApiModelProperty(value="ID", hidden=true)
    private Long id;
    @ManyToMany(fetch=FetchType.EAGER)
    @ApiModelProperty(value="\u7528\u6237\u89d2\u8272")
    @JoinTable(name="sys_users_roles", joinColumns={@JoinColumn(name="user_id", referencedColumnName="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id", referencedColumnName="role_id")})
    private Set<Role> roles;
    @ManyToMany(fetch=FetchType.EAGER)
    @ApiModelProperty(value="\u7528\u6237\u5c97\u4f4d")
    @JoinTable(name="sys_users_jobs", joinColumns={@JoinColumn(name="user_id", referencedColumnName="user_id")}, inverseJoinColumns={@JoinColumn(name="job_id", referencedColumnName="job_id")})
    private Set<Job> jobs;
    @OneToOne
    @JoinColumn(name="dept_id")
    @ApiModelProperty(value="\u7528\u6237\u90e8\u95e8")
    private Dept dept;
    @NotBlank
    @Column(unique=true)
    @ApiModelProperty(value="\u7528\u6237\u540d\u79f0")
    private String username;
    @NotBlank
    @ApiModelProperty(value="\u7528\u6237\u6635\u79f0")
    private String nickName;
    @Email
    @NotBlank
    @ApiModelProperty(value="\u90ae\u7bb1")
    private String email;
    @NotBlank
    @ApiModelProperty(value="\u7535\u8bdd\u53f7\u7801")
    private String phone;
    @ApiModelProperty(value="\u7528\u6237\u6027\u522b")
    private String gender;
    @ApiModelProperty(value="\u5934\u50cf\u771f\u5b9e\u540d\u79f0", hidden=true)
    private String avatarName;
    @ApiModelProperty(value="\u5934\u50cf\u5b58\u50a8\u7684\u8def\u5f84", hidden=true)
    private String avatarPath;
    @ApiModelProperty(value="\u5bc6\u7801")
    private String password;
    @NotNull
    @ApiModelProperty(value="\u662f\u5426\u542f\u7528")
    private Boolean enabled;
    @ApiModelProperty(value="\u662f\u5426\u4e3aadmin\u8d26\u53f7", hidden=true)
    private Boolean isAdmin = false;
    @Column(name="pwd_reset_time")
    @ApiModelProperty(value="\u6700\u540e\u4fee\u6539\u5bc6\u7801\u7684\u65f6\u95f4", hidden=true)
    private Date pwdResetTime;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id) && Objects.equals(this.username, user.username);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.username);
    }

    public Long getId() {
        return this.id;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public Set<Job> getJobs() {
        return this.jobs;
    }

    public Dept getDept() {
        return this.dept;
    }

    public String getUsername() {
        return this.username;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getGender() {
        return this.gender;
    }

    public String getAvatarName() {
        return this.avatarName;
    }

    public String getAvatarPath() {
        return this.avatarPath;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public Date getPwdResetTime() {
        return this.pwdResetTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void setJobs(Set<Job> jobs) {
        this.jobs = jobs;
    }

    public void setDept(Dept dept) {
        this.dept = dept;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setAvatarName(String avatarName) {
        this.avatarName = avatarName;
    }

    public void setAvatarPath(String avatarPath) {
        this.avatarPath = avatarPath;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setIsAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void setPwdResetTime(Date pwdResetTime) {
        this.pwdResetTime = pwdResetTime;
    }
}

