/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.security.rest;

import cn.hutool.core.util.IdUtil;
import com.wf.captcha.base.Captcha;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import me.zhengjie.annotation.Log;
import me.zhengjie.annotation.rest.AnonymousDeleteMapping;
import me.zhengjie.annotation.rest.AnonymousGetMapping;
import me.zhengjie.annotation.rest.AnonymousPostMapping;
import me.zhengjie.config.RsaProperties;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.security.config.bean.LoginCodeEnum;
import me.zhengjie.modules.security.config.bean.LoginProperties;
import me.zhengjie.modules.security.config.bean.SecurityProperties;
import me.zhengjie.modules.security.rest.AuthorizationController;
import me.zhengjie.modules.security.security.TokenProvider;
import me.zhengjie.modules.security.service.OnlineUserService;
import me.zhengjie.modules.security.service.dto.AuthUserDto;
import me.zhengjie.modules.security.service.dto.JwtUserDto;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.RsaUtils;
import me.zhengjie.utils.SecurityUtils;
import me.zhengjie.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
@Api(tags={"\u7cfb\u7edf\uff1a\u7cfb\u7edf\u6388\u6743\u63a5\u53e3"})
public class AuthorizationController {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationController.class);
    private final SecurityProperties properties;
    private final RedisUtils redisUtils;
    private final OnlineUserService onlineUserService;
    private final TokenProvider tokenProvider;
    private final AuthenticationManagerBuilder authenticationManagerBuilder;
    @Resource
    private LoginProperties loginProperties;

    @Log(value="\u7528\u6237\u767b\u5f55")
    @ApiOperation(value="\u767b\u5f55\u6388\u6743")
    @AnonymousPostMapping(value={"/login"})
    public ResponseEntity<Object> login(@Validated @RequestBody AuthUserDto authUser, HttpServletRequest request) throws Exception {
        String password = RsaUtils.decryptByPrivateKey((String)RsaProperties.privateKey, (String)authUser.getPassword());
        String code = (String)this.redisUtils.get(authUser.getUuid());
        this.redisUtils.del(new String[]{authUser.getUuid()});
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BadRequestException("\u9a8c\u8bc1\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f");
        }
        if (StringUtils.isBlank((CharSequence)authUser.getCode()) || !authUser.getCode().equalsIgnoreCase(code)) {
            throw new BadRequestException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)authUser.getUsername(), (Object)password);
        Authentication authentication = ((AuthenticationManager)this.authenticationManagerBuilder.getObject()).authenticate((Authentication)authenticationToken);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        String token = this.tokenProvider.createToken(authentication);
        JwtUserDto jwtUserDto = (JwtUserDto)authentication.getPrincipal();
        this.onlineUserService.save(jwtUserDto, token, request);
        1 authInfo = new /* Unavailable Anonymous Inner Class!! */;
        if (this.loginProperties.isSingleLogin()) {
            this.onlineUserService.checkLoginOnUser(authUser.getUsername(), token);
        }
        return ResponseEntity.ok((Object)authInfo);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/info"})
    public ResponseEntity<Object> getUserInfo() {
        return ResponseEntity.ok((Object)SecurityUtils.getCurrentUser());
    }

    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @AnonymousGetMapping(value={"/code"})
    public ResponseEntity<Object> getCode() {
        Captcha captcha = this.loginProperties.getCaptcha();
        String uuid = this.properties.getCodeKey() + IdUtil.simpleUUID();
        String captchaValue = captcha.text();
        if (captcha.getCharType() - 1 == LoginCodeEnum.ARITHMETIC.ordinal() && captchaValue.contains(".")) {
            captchaValue = captchaValue.split("\\.")[0];
        }
        this.redisUtils.set(uuid, (Object)captchaValue, this.loginProperties.getLoginCode().getExpiration().longValue(), TimeUnit.MINUTES);
        2 imgResult = new /* Unavailable Anonymous Inner Class!! */;
        return ResponseEntity.ok((Object)imgResult);
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    @AnonymousDeleteMapping(value={"/logout"})
    public ResponseEntity<Object> logout(HttpServletRequest request) {
        this.onlineUserService.logout(this.tokenProvider.getToken(request));
        return new ResponseEntity(HttpStatus.OK);
    }

    public AuthorizationController(SecurityProperties properties, RedisUtils redisUtils, OnlineUserService onlineUserService, TokenProvider tokenProvider, AuthenticationManagerBuilder authenticationManagerBuilder) {
        this.properties = properties;
        this.redisUtils = redisUtils;
        this.onlineUserService = onlineUserService;
        this.tokenProvider = tokenProvider;
        this.authenticationManagerBuilder = authenticationManagerBuilder;
    }

    static /* synthetic */ SecurityProperties access$000(AuthorizationController x0) {
        return x0.properties;
    }
}

