/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.repository;

import java.util.Date;
import java.util.List;
import java.util.Set;
import me.zhengjie.modules.system.domain.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

public interface UserRepository
extends JpaRepository<User, Long>,
JpaSpecificationExecutor<User> {
    public User findByUsername(String var1);

    public User findByEmail(String var1);

    public User findByPhone(String var1);

    @Modifying
    @Query(value="update sys_user set password = ?2 , pwd_reset_time = ?3 where username = ?1", nativeQuery=true)
    public void updatePass(String var1, String var2, Date var3);

    @Modifying
    @Query(value="update sys_user set email = ?2 where username = ?1", nativeQuery=true)
    public void updateEmail(String var1, String var2);

    @Query(value="SELECT u.* FROM sys_user u, sys_users_roles r WHERE u.user_id = r.user_id AND r.role_id = ?1", nativeQuery=true)
    public List<User> findByRoleId(Long var1);

    @Query(value="SELECT u.* FROM sys_user u, sys_users_roles r, sys_roles_depts d WHERE u.user_id = r.user_id AND r.role_id = d.role_id AND d.dept_id = ?1 group by u.user_id", nativeQuery=true)
    public List<User> findByRoleDeptId(Long var1);

    @Query(value="SELECT u.* FROM sys_user u, sys_users_roles ur, sys_roles_menus rm WHERE\nu.user_id = ur.user_id AND ur.role_id = rm.role_id AND rm.menu_id = ?1 group by u.user_id", nativeQuery=true)
    public List<User> findByMenuId(Long var1);

    public void deleteAllByIdIn(Set<Long> var1);

    @Query(value="SELECT count(1) FROM sys_user u, sys_users_jobs j WHERE u.user_id = j.user_id AND j.job_id IN ?1", nativeQuery=true)
    public int countByJobs(Set<Long> var1);

    @Query(value="SELECT count(1) FROM sys_user u WHERE u.dept_id IN ?1", nativeQuery=true)
    public int countByDepts(Set<Long> var1);

    @Query(value="SELECT count(1) FROM sys_user u, sys_users_roles r WHERE u.user_id = r.user_id AND r.role_id in ?1", nativeQuery=true)
    public int countByRoles(Set<Long> var1);
}

