/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.annotation.Log;
import me.zhengjie.modules.mnt.service.DeployHistoryService;
import me.zhengjie.modules.mnt.service.dto.DeployHistoryQueryCriteria;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fd0\u7ef4\uff1a\u90e8\u7f72\u5386\u53f2\u7ba1\u7406"})
@RequestMapping(value={"/api/deployHistory"})
public class DeployHistoryController {
    private final DeployHistoryService deployhistoryService;

    @ApiOperation(value="\u5bfc\u51fa\u90e8\u7f72\u5386\u53f2\u6570\u636e")
    @GetMapping(value={"/download"})
    @PreAuthorize(value="@el.check('deployHistory:list')")
    public void exportDeployHistory(HttpServletResponse response, DeployHistoryQueryCriteria criteria) throws IOException {
        this.deployhistoryService.download(this.deployhistoryService.queryAll(criteria), response);
    }

    @ApiOperation(value="\u67e5\u8be2\u90e8\u7f72\u5386\u53f2")
    @GetMapping
    @PreAuthorize(value="@el.check('deployHistory:list')")
    public ResponseEntity<Object> queryDeployHistory(DeployHistoryQueryCriteria criteria, Pageable pageable) {
        return new ResponseEntity(this.deployhistoryService.queryAll(criteria, pageable), HttpStatus.OK);
    }

    @Log(value="\u5220\u9664DeployHistory")
    @ApiOperation(value="\u5220\u9664\u90e8\u7f72\u5386\u53f2")
    @DeleteMapping
    @PreAuthorize(value="@el.check('deployHistory:del')")
    public ResponseEntity<Object> deleteDeployHistory(@RequestBody Set<String> ids) {
        this.deployhistoryService.delete(ids);
        return new ResponseEntity(HttpStatus.OK);
    }

    public DeployHistoryController(DeployHistoryService deployhistoryService) {
        this.deployhistoryService = deployhistoryService;
    }
}

