/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.annotation.Log;
import me.zhengjie.modules.mnt.domain.App;
import me.zhengjie.modules.mnt.service.AppService;
import me.zhengjie.modules.mnt.service.dto.AppQueryCriteria;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fd0\u7ef4\uff1a\u5e94\u7528\u7ba1\u7406"})
@RequestMapping(value={"/api/app"})
public class AppController {
    private final AppService appService;

    @ApiOperation(value="\u5bfc\u51fa\u5e94\u7528\u6570\u636e")
    @GetMapping(value={"/download"})
    @PreAuthorize(value="@el.check('app:list')")
    public void exportApp(HttpServletResponse response, AppQueryCriteria criteria) throws IOException {
        this.appService.download(this.appService.queryAll(criteria), response);
    }

    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528")
    @GetMapping
    @PreAuthorize(value="@el.check('app:list')")
    public ResponseEntity<Object> queryApp(AppQueryCriteria criteria, Pageable pageable) {
        return new ResponseEntity(this.appService.queryAll(criteria, pageable), HttpStatus.OK);
    }

    @Log(value="\u65b0\u589e\u5e94\u7528")
    @ApiOperation(value="\u65b0\u589e\u5e94\u7528")
    @PostMapping
    @PreAuthorize(value="@el.check('app:add')")
    public ResponseEntity<Object> createApp(@Validated @RequestBody App resources) {
        this.appService.create(resources);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Log(value="\u4fee\u6539\u5e94\u7528")
    @ApiOperation(value="\u4fee\u6539\u5e94\u7528")
    @PutMapping
    @PreAuthorize(value="@el.check('app:edit')")
    public ResponseEntity<Object> updateApp(@Validated @RequestBody App resources) {
        this.appService.update(resources);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Log(value="\u5220\u9664\u5e94\u7528")
    @ApiOperation(value="\u5220\u9664\u5e94\u7528")
    @DeleteMapping
    @PreAuthorize(value="@el.check('app:del')")
    public ResponseEntity<Object> deleteApp(@RequestBody Set<Long> ids) {
        this.appService.delete(ids);
        return new ResponseEntity(HttpStatus.OK);
    }

    public AppController(AppService appService) {
        this.appService = appService;
    }
}

