/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.exception.EntityExistException;
import me.zhengjie.modules.security.service.UserCacheManager;
import me.zhengjie.modules.security.service.dto.AuthorityDto;
import me.zhengjie.modules.system.domain.Menu;
import me.zhengjie.modules.system.domain.Role;
import me.zhengjie.modules.system.domain.User;
import me.zhengjie.modules.system.repository.RoleRepository;
import me.zhengjie.modules.system.repository.UserRepository;
import me.zhengjie.modules.system.service.RoleService;
import me.zhengjie.modules.system.service.dto.RoleDto;
import me.zhengjie.modules.system.service.dto.RoleQueryCriteria;
import me.zhengjie.modules.system.service.dto.RoleSmallDto;
import me.zhengjie.modules.system.service.dto.UserDto;
import me.zhengjie.modules.system.service.mapstruct.RoleMapper;
import me.zhengjie.modules.system.service.mapstruct.RoleSmallMapper;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.ValidationUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@CacheConfig(cacheNames={"role"})
public class RoleServiceImpl
implements RoleService {
    private final RoleRepository roleRepository;
    private final RoleMapper roleMapper;
    private final RoleSmallMapper roleSmallMapper;
    private final RedisUtils redisUtils;
    private final UserRepository userRepository;
    private final UserCacheManager userCacheManager;

    public List<RoleDto> queryAll() {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"level"});
        return this.roleMapper.toDto(this.roleRepository.findAll(sort));
    }

    public List<RoleDto> queryAll(RoleQueryCriteria criteria) {
        return this.roleMapper.toDto(this.roleRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder)));
    }

    public Object queryAll(RoleQueryCriteria criteria, Pageable pageable) {
        Page page = this.roleRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), pageable);
        return PageUtil.toPage((Page)page.map(arg_0 -> ((RoleMapper)this.roleMapper).toDto(arg_0)));
    }

    @Cacheable(key="'id:' + #p0")
    @Transactional(rollbackFor={Exception.class})
    public RoleDto findById(long id) {
        Role role = this.roleRepository.findById((Object)id).orElseGet(Role::new);
        ValidationUtil.isNull((Object)role.getId(), (String)"Role", (String)"id", (Object)id);
        return (RoleDto)this.roleMapper.toDto((Object)role);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(Role resources) {
        if (this.roleRepository.findByName(resources.getName()) != null) {
            throw new EntityExistException(Role.class, "username", resources.getName());
        }
        this.roleRepository.save((Object)resources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(Role resources) {
        Role role = this.roleRepository.findById((Object)resources.getId()).orElseGet(Role::new);
        ValidationUtil.isNull((Object)role.getId(), (String)"Role", (String)"id", (Object)resources.getId());
        Role role1 = this.roleRepository.findByName(resources.getName());
        if (role1 != null && !role1.getId().equals(role.getId())) {
            throw new EntityExistException(Role.class, "username", resources.getName());
        }
        role.setName(resources.getName());
        role.setDescription(resources.getDescription());
        role.setDataScope(resources.getDataScope());
        role.setDepts(resources.getDepts());
        role.setLevel(resources.getLevel());
        this.roleRepository.save((Object)role);
        this.delCaches(role.getId(), null);
    }

    public void updateMenu(Role resources, RoleDto roleDTO) {
        Role role = (Role)this.roleMapper.toEntity((Object)roleDTO);
        List users = this.userRepository.findByRoleId(role.getId());
        role.setMenus(resources.getMenus());
        this.delCaches(resources.getId(), users);
        this.roleRepository.save((Object)role);
    }

    @Transactional(rollbackFor={Exception.class})
    public void untiedMenu(Long menuId) {
        this.roleRepository.untiedMenu(menuId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<Long> ids) {
        for (Long id : ids) {
            this.delCaches(id, null);
        }
        this.roleRepository.deleteAllByIdIn(ids);
    }

    public List<RoleSmallDto> findByUsersId(Long id) {
        return this.roleSmallMapper.toDto(new ArrayList(this.roleRepository.findByUserId(id)));
    }

    public Integer findByRoles(Set<Role> roles) {
        if (roles.size() == 0) {
            return Integer.MAX_VALUE;
        }
        HashSet<RoleDto> roleDtos = new HashSet<RoleDto>();
        for (Role role : roles) {
            roleDtos.add(this.findById(role.getId().longValue()));
        }
        return (Integer)Collections.min(roleDtos.stream().map(RoleDto::getLevel).collect(Collectors.toList()));
    }

    @Cacheable(key="'auth:' + #p0.id")
    public List<AuthorityDto> mapToGrantedAuthorities(UserDto user) {
        Set<Object> permissions = new HashSet<String>();
        if (user.getIsAdmin().booleanValue()) {
            permissions.add("admin");
            return permissions.stream().map(AuthorityDto::new).collect(Collectors.toList());
        }
        Set roles = this.roleRepository.findByUserId(user.getId());
        permissions = roles.stream().flatMap(role -> role.getMenus().stream()).map(Menu::getPermission).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        return permissions.stream().map(AuthorityDto::new).collect(Collectors.toList());
    }

    public void download(List<RoleDto> roles, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (RoleDto role : roles) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u89d2\u8272\u540d\u79f0", role.getName());
            map.put("\u89d2\u8272\u7ea7\u522b", role.getLevel());
            map.put("\u63cf\u8ff0", role.getDescription());
            map.put("\u521b\u5efa\u65e5\u671f", role.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public void verification(Set<Long> ids) {
        if (this.userRepository.countByRoles(ids) > 0) {
            throw new BadRequestException("\u6240\u9009\u89d2\u8272\u5b58\u5728\u7528\u6237\u5173\u8054\uff0c\u8bf7\u89e3\u9664\u5173\u8054\u518d\u8bd5\uff01");
        }
    }

    public List<Role> findInMenuId(List<Long> menuIds) {
        return this.roleRepository.findInMenuId(menuIds);
    }

    public void delCaches(Long id, List<User> users) {
        List list = users = CollectionUtil.isEmpty(users) ? this.userRepository.findByRoleId(id) : users;
        if (CollectionUtil.isNotEmpty((Collection)users)) {
            users.forEach(item -> this.userCacheManager.cleanUserCache(item.getUsername()));
            Set userIds = users.stream().map(User::getId).collect(Collectors.toSet());
            this.redisUtils.delByKeys("data::user:", userIds);
            this.redisUtils.delByKeys("menu::user:", userIds);
            this.redisUtils.delByKeys("role::auth:", userIds);
        }
        this.redisUtils.del(new String[]{"role::id:" + id});
    }

    public RoleServiceImpl(RoleRepository roleRepository, RoleMapper roleMapper, RoleSmallMapper roleSmallMapper, RedisUtils redisUtils, UserRepository userRepository, UserCacheManager userCacheManager) {
        this.roleRepository = roleRepository;
        this.roleMapper = roleMapper;
        this.roleSmallMapper = roleSmallMapper;
        this.redisUtils = redisUtils;
        this.userRepository = userRepository;
        this.userCacheManager = userCacheManager;
    }
}

