/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import me.zhengjie.annotation.Log;
import me.zhengjie.base.BaseEntity;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.system.domain.DictDetail;
import me.zhengjie.modules.system.service.DictDetailService;
import me.zhengjie.modules.system.service.dto.DictDetailQueryCriteria;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7cfb\u7edf\uff1a\u5b57\u5178\u8be6\u60c5\u7ba1\u7406"})
@RequestMapping(value={"/api/dictDetail"})
public class DictDetailController {
    private final DictDetailService dictDetailService;
    private static final String ENTITY_NAME = "dictDetail";

    @ApiOperation(value="\u67e5\u8be2\u5b57\u5178\u8be6\u60c5")
    @GetMapping
    public ResponseEntity<Object> queryDictDetail(DictDetailQueryCriteria criteria, @PageableDefault(sort={"dictSort"}, direction=Sort.Direction.ASC) Pageable pageable) {
        return new ResponseEntity((Object)this.dictDetailService.queryAll(criteria, pageable), HttpStatus.OK);
    }

    @ApiOperation(value="\u67e5\u8be2\u591a\u4e2a\u5b57\u5178\u8be6\u60c5")
    @GetMapping(value={"/map"})
    public ResponseEntity<Object> getDictDetailMaps(@RequestParam String dictName) {
        String[] names = dictName.split("[,\uff0c]");
        HashMap<String, List> dictMap = new HashMap<String, List>(16);
        for (String name : names) {
            dictMap.put(name, this.dictDetailService.getDictByName(name));
        }
        return new ResponseEntity(dictMap, HttpStatus.OK);
    }

    @Log(value="\u65b0\u589e\u5b57\u5178\u8be6\u60c5")
    @ApiOperation(value="\u65b0\u589e\u5b57\u5178\u8be6\u60c5")
    @PostMapping
    @PreAuthorize(value="@el.check('dict:add')")
    public ResponseEntity<Object> createDictDetail(@Validated @RequestBody DictDetail resources) {
        if (resources.getId() != null) {
            throw new BadRequestException("A new dictDetail cannot already have an ID");
        }
        this.dictDetailService.create(resources);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Log(value="\u4fee\u6539\u5b57\u5178\u8be6\u60c5")
    @ApiOperation(value="\u4fee\u6539\u5b57\u5178\u8be6\u60c5")
    @PutMapping
    @PreAuthorize(value="@el.check('dict:edit')")
    public ResponseEntity<Object> updateDictDetail(@Validated(value={BaseEntity.Update.class}) @RequestBody DictDetail resources) {
        this.dictDetailService.update(resources);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Log(value="\u5220\u9664\u5b57\u5178\u8be6\u60c5")
    @ApiOperation(value="\u5220\u9664\u5b57\u5178\u8be6\u60c5")
    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="@el.check('dict:del')")
    public ResponseEntity<Object> deleteDictDetail(@PathVariable Long id) {
        this.dictDetailService.delete(id);
        return new ResponseEntity(HttpStatus.OK);
    }

    public DictDetailController(DictDetailService dictDetailService) {
        this.dictDetailService = dictDetailService;
    }
}

