/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.security.security;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import me.zhengjie.modules.security.config.bean.SecurityProperties;
import me.zhengjie.utils.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;

@Component
public class TokenProvider
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TokenProvider.class);
    private final SecurityProperties properties;
    private final RedisUtils redisUtils;
    public static final String AUTHORITIES_KEY = "user";
    private JwtParser jwtParser;
    private JwtBuilder jwtBuilder;

    public TokenProvider(SecurityProperties properties, RedisUtils redisUtils) {
        this.properties = properties;
        this.redisUtils = redisUtils;
    }

    public void afterPropertiesSet() {
        byte[] keyBytes = (byte[])Decoders.BASE64.decode((Object)this.properties.getBase64Secret());
        SecretKey key = Keys.hmacShaKeyFor((byte[])keyBytes);
        this.jwtParser = Jwts.parserBuilder().setSigningKey((Key)key).build();
        this.jwtBuilder = Jwts.builder().signWith((Key)key, SignatureAlgorithm.HS512);
    }

    public String createToken(Authentication authentication) {
        return this.jwtBuilder.setId(IdUtil.simpleUUID()).claim(AUTHORITIES_KEY, (Object)authentication.getName()).setSubject(authentication.getName()).compact();
    }

    Authentication getAuthentication(String token) {
        Claims claims = this.getClaims(token);
        User principal = new User(claims.getSubject(), "******", new ArrayList());
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)token, new ArrayList());
    }

    public Claims getClaims(String token) {
        return (Claims)this.jwtParser.parseClaimsJws(token).getBody();
    }

    public void checkRenewal(String token) {
        long time = this.redisUtils.getExpire((Object)(this.properties.getOnlineKey() + token)) * 1000L;
        DateTime expireDate = DateUtil.offset((Date)new Date(), (DateField)DateField.MILLISECOND, (int)((int)time));
        long differ = expireDate.getTime() - System.currentTimeMillis();
        if (differ <= this.properties.getDetect()) {
            long renew = time + this.properties.getRenew();
            this.redisUtils.expire(this.properties.getOnlineKey() + token, renew, TimeUnit.MILLISECONDS);
        }
    }

    public String getToken(HttpServletRequest request) {
        String requestHeader = request.getHeader(this.properties.getHeader());
        if (requestHeader != null && requestHeader.startsWith(this.properties.getTokenStartWith())) {
            return requestHeader.substring(7);
        }
        return null;
    }
}

