/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.exception.EntityExistException;
import me.zhengjie.modules.system.domain.Menu;
import me.zhengjie.modules.system.domain.Role;
import me.zhengjie.modules.system.domain.User;
import me.zhengjie.modules.system.domain.vo.MenuMetaVo;
import me.zhengjie.modules.system.domain.vo.MenuVo;
import me.zhengjie.modules.system.repository.MenuRepository;
import me.zhengjie.modules.system.repository.UserRepository;
import me.zhengjie.modules.system.service.MenuService;
import me.zhengjie.modules.system.service.RoleService;
import me.zhengjie.modules.system.service.dto.MenuDto;
import me.zhengjie.modules.system.service.dto.MenuQueryCriteria;
import me.zhengjie.modules.system.service.dto.RoleSmallDto;
import me.zhengjie.modules.system.service.mapstruct.MenuMapper;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.StringUtils;
import me.zhengjie.utils.ValidationUtil;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@CacheConfig(cacheNames={"menu"})
public class MenuServiceImpl
implements MenuService {
    private final MenuRepository menuRepository;
    private final UserRepository userRepository;
    private final MenuMapper menuMapper;
    private final RoleService roleService;
    private final RedisUtils redisUtils;

    public List<MenuDto> queryAll(MenuQueryCriteria criteria, Boolean isQuery) throws Exception {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"menuSort"});
        if (Boolean.TRUE.equals(isQuery)) {
            criteria.setPidIsNull(Boolean.valueOf(true));
            List fields = QueryHelp.getAllFields(criteria.getClass(), new ArrayList());
            for (Field field : fields) {
                field.setAccessible(true);
                Object val = field.get(criteria);
                if ("pidIsNull".equals(field.getName()) || !ObjectUtil.isNotNull((Object)val)) continue;
                criteria.setPidIsNull(null);
                break;
            }
        }
        return this.menuMapper.toDto(this.menuRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), sort));
    }

    @Cacheable(key="'id:' + #p0")
    public MenuDto findById(long id) {
        Menu menu = this.menuRepository.findById((Object)id).orElseGet(Menu::new);
        ValidationUtil.isNull((Object)menu.getId(), (String)"Menu", (String)"id", (Object)id);
        return (MenuDto)this.menuMapper.toDto((Object)menu);
    }

    @Cacheable(key="'user:' + #p0")
    public List<MenuDto> findByUser(Long currentUserId) {
        List roles = this.roleService.findByUsersId(currentUserId);
        Set roleIds = roles.stream().map(RoleSmallDto::getId).collect(Collectors.toSet());
        LinkedHashSet menus = this.menuRepository.findByRoleIdsAndTypeNot(roleIds, 2);
        return menus.stream().map(arg_0 -> ((MenuMapper)this.menuMapper).toDto(arg_0)).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(Menu resources) {
        if (this.menuRepository.findByTitle(resources.getTitle()) != null) {
            throw new EntityExistException(Menu.class, "title", resources.getTitle());
        }
        if (StringUtils.isNotBlank((CharSequence)resources.getComponentName()) && this.menuRepository.findByComponentName(resources.getComponentName()) != null) {
            throw new EntityExistException(Menu.class, "componentName", resources.getComponentName());
        }
        if (resources.getPid().equals(0L)) {
            resources.setPid(null);
        }
        if (resources.getIFrame().booleanValue()) {
            String http = "http://";
            String https = "https://";
            if (!resources.getPath().toLowerCase().startsWith(http) && !resources.getPath().toLowerCase().startsWith(https)) {
                throw new BadRequestException("\u5916\u94fe\u5fc5\u987b\u4ee5http://\u6216\u8005https://\u5f00\u5934");
            }
        }
        this.menuRepository.save((Object)resources);
        resources.setSubCount(Integer.valueOf(0));
        this.updateSubCnt(resources.getPid());
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(Menu resources) {
        Menu menu1;
        if (resources.getId().equals(resources.getPid())) {
            throw new BadRequestException("\u4e0a\u7ea7\u4e0d\u80fd\u4e3a\u81ea\u5df1");
        }
        Menu menu = this.menuRepository.findById((Object)resources.getId()).orElseGet(Menu::new);
        ValidationUtil.isNull((Object)menu.getId(), (String)"Permission", (String)"id", (Object)resources.getId());
        if (resources.getIFrame().booleanValue()) {
            String http = "http://";
            String https = "https://";
            if (!resources.getPath().toLowerCase().startsWith(http) && !resources.getPath().toLowerCase().startsWith(https)) {
                throw new BadRequestException("\u5916\u94fe\u5fc5\u987b\u4ee5http://\u6216\u8005https://\u5f00\u5934");
            }
        }
        if ((menu1 = this.menuRepository.findByTitle(resources.getTitle())) != null && !menu1.getId().equals(menu.getId())) {
            throw new EntityExistException(Menu.class, "title", resources.getTitle());
        }
        if (resources.getPid().equals(0L)) {
            resources.setPid(null);
        }
        Long oldPid = menu.getPid();
        Long newPid = resources.getPid();
        if (StringUtils.isNotBlank((CharSequence)resources.getComponentName()) && (menu1 = this.menuRepository.findByComponentName(resources.getComponentName())) != null && !menu1.getId().equals(menu.getId())) {
            throw new EntityExistException(Menu.class, "componentName", resources.getComponentName());
        }
        menu.setTitle(resources.getTitle());
        menu.setComponent(resources.getComponent());
        menu.setPath(resources.getPath());
        menu.setIcon(resources.getIcon());
        menu.setIFrame(resources.getIFrame());
        menu.setPid(resources.getPid());
        menu.setMenuSort(resources.getMenuSort());
        menu.setCache(resources.getCache());
        menu.setHidden(resources.getHidden());
        menu.setComponentName(resources.getComponentName());
        menu.setPermission(resources.getPermission());
        menu.setType(resources.getType());
        this.menuRepository.save((Object)menu);
        this.updateSubCnt(oldPid);
        this.updateSubCnt(newPid);
        this.delCaches(resources.getId());
    }

    public Set<Menu> getChildMenus(List<Menu> menuList, Set<Menu> menuSet) {
        for (Menu menu : menuList) {
            menuSet.add(menu);
            List menus = this.menuRepository.findByPidOrderByMenuSort(menu.getId().longValue());
            if (menus == null || menus.size() == 0) continue;
            this.getChildMenus(menus, menuSet);
        }
        return menuSet;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<Menu> menuSet) {
        for (Menu menu : menuSet) {
            this.delCaches(menu.getId());
            this.roleService.untiedMenu(menu.getId());
            this.menuRepository.deleteById((Object)menu.getId());
            this.updateSubCnt(menu.getPid());
        }
    }

    public List<MenuDto> getMenus(Long pid) {
        List menus = pid != null && !pid.equals(0L) ? this.menuRepository.findByPidOrderByMenuSort(pid.longValue()) : this.menuRepository.findByPidIsNullOrderByMenuSort();
        return this.menuMapper.toDto(menus);
    }

    public List<MenuDto> getSuperior(MenuDto menuDto, List<Menu> menus) {
        if (menuDto.getPid() == null) {
            menus.addAll(this.menuRepository.findByPidIsNullOrderByMenuSort());
            return this.menuMapper.toDto(menus);
        }
        menus.addAll(this.menuRepository.findByPidOrderByMenuSort(menuDto.getPid().longValue()));
        return this.getSuperior(this.findById(menuDto.getPid().longValue()), menus);
    }

    public List<MenuDto> buildTree(List<MenuDto> menuDtos) {
        List<Object> trees = new ArrayList<MenuDto>();
        HashSet<Long> ids = new HashSet<Long>();
        for (MenuDto menuDTO : menuDtos) {
            if (menuDTO.getPid() == null) {
                trees.add(menuDTO);
            }
            for (MenuDto it : menuDtos) {
                if (!menuDTO.getId().equals(it.getPid())) continue;
                if (menuDTO.getChildren() == null) {
                    menuDTO.setChildren(new ArrayList());
                }
                menuDTO.getChildren().add(it);
                ids.add(it.getId());
            }
        }
        if (trees.size() == 0) {
            trees = menuDtos.stream().filter(s -> !ids.contains(s.getId())).collect(Collectors.toList());
        }
        return trees;
    }

    public List<MenuVo> buildMenus(List<MenuDto> menuDtos) {
        LinkedList<MenuVo> list = new LinkedList<MenuVo>();
        menuDtos.forEach(menuDTO -> {
            if (menuDTO != null) {
                List menuDtoList = menuDTO.getChildren();
                MenuVo menuVo = new MenuVo();
                menuVo.setName(ObjectUtil.isNotEmpty((Object)menuDTO.getComponentName()) ? menuDTO.getComponentName() : menuDTO.getTitle());
                menuVo.setPath(menuDTO.getPid() == null ? "/" + menuDTO.getPath() : menuDTO.getPath());
                menuVo.setHidden(menuDTO.getHidden());
                if (!menuDTO.getIFrame().booleanValue()) {
                    if (menuDTO.getPid() == null) {
                        menuVo.setComponent(StringUtils.isEmpty((CharSequence)menuDTO.getComponent()) ? "Layout" : menuDTO.getComponent());
                    } else if (menuDTO.getType() == 0) {
                        menuVo.setComponent(StringUtils.isEmpty((CharSequence)menuDTO.getComponent()) ? "ParentView" : menuDTO.getComponent());
                    } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{menuDTO.getComponent()})) {
                        menuVo.setComponent(menuDTO.getComponent());
                    }
                }
                menuVo.setMeta(new MenuMetaVo(menuDTO.getTitle(), menuDTO.getIcon(), Boolean.valueOf(menuDTO.getCache() == false)));
                if (CollectionUtil.isNotEmpty((Collection)menuDtoList)) {
                    menuVo.setAlwaysShow(Boolean.valueOf(true));
                    menuVo.setRedirect("noredirect");
                    menuVo.setChildren(this.buildMenus(menuDtoList));
                } else if (menuDTO.getPid() == null) {
                    MenuVo menuVo1 = new MenuVo();
                    menuVo1.setMeta(menuVo.getMeta());
                    if (!menuDTO.getIFrame().booleanValue()) {
                        menuVo1.setPath("index");
                        menuVo1.setName(menuVo.getName());
                        menuVo1.setComponent(menuVo.getComponent());
                    } else {
                        menuVo1.setPath(menuDTO.getPath());
                    }
                    menuVo.setName(null);
                    menuVo.setMeta(null);
                    menuVo.setComponent("Layout");
                    ArrayList<MenuVo> list1 = new ArrayList<MenuVo>();
                    list1.add(menuVo1);
                    menuVo.setChildren(list1);
                }
                list.add(menuVo);
            }
        });
        return list;
    }

    public Menu findOne(Long id) {
        Menu menu = this.menuRepository.findById((Object)id).orElseGet(Menu::new);
        ValidationUtil.isNull((Object)menu.getId(), (String)"Menu", (String)"id", (Object)id);
        return menu;
    }

    public void download(List<MenuDto> menuDtos, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (MenuDto menuDTO : menuDtos) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u83dc\u5355\u6807\u9898", menuDTO.getTitle());
            map.put("\u83dc\u5355\u7c7b\u578b", menuDTO.getType() == null ? "\u76ee\u5f55" : (menuDTO.getType() == 1 ? "\u83dc\u5355" : "\u6309\u94ae"));
            map.put("\u6743\u9650\u6807\u8bc6", menuDTO.getPermission());
            map.put("\u5916\u94fe\u83dc\u5355", menuDTO.getIFrame() != false ? "\u662f" : "\u5426");
            map.put("\u83dc\u5355\u53ef\u89c1", menuDTO.getHidden() != false ? "\u5426" : "\u662f");
            map.put("\u662f\u5426\u7f13\u5b58", menuDTO.getCache() != false ? "\u662f" : "\u5426");
            map.put("\u521b\u5efa\u65e5\u671f", menuDTO.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    private void updateSubCnt(Long menuId) {
        if (menuId != null) {
            int count = this.menuRepository.countByPid(menuId);
            this.menuRepository.updateSubCntById(count, menuId);
        }
    }

    public void delCaches(Long id) {
        List users = this.userRepository.findByMenuId(id);
        this.redisUtils.del(new String[]{"menu::id:" + id});
        this.redisUtils.delByKeys("menu::user:", users.stream().map(User::getId).collect(Collectors.toSet()));
        List roles = this.roleService.findInMenuId((List)new /* Unavailable Anonymous Inner Class!! */);
        this.redisUtils.delByKeys("role::id:", roles.stream().map(Role::getId).collect(Collectors.toSet()));
    }

    public MenuServiceImpl(MenuRepository menuRepository, UserRepository userRepository, MenuMapper menuMapper, RoleService roleService, RedisUtils redisUtils) {
        this.menuRepository = menuRepository;
        this.userRepository = userRepository;
        this.menuMapper = menuMapper;
        this.roleService = roleService;
        this.redisUtils = redisUtils;
    }
}

