/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.rest;

import cn.hutool.core.collection.CollectionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.annotation.Log;
import me.zhengjie.base.BaseEntity;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.system.domain.Dept;
import me.zhengjie.modules.system.service.DeptService;
import me.zhengjie.modules.system.service.dto.DeptDto;
import me.zhengjie.modules.system.service.dto.DeptQueryCriteria;
import me.zhengjie.utils.PageUtil;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7cfb\u7edf\uff1a\u90e8\u95e8\u7ba1\u7406"})
@RequestMapping(value={"/api/dept"})
public class DeptController {
    private final DeptService deptService;
    private static final String ENTITY_NAME = "dept";

    @ApiOperation(value="\u5bfc\u51fa\u90e8\u95e8\u6570\u636e")
    @GetMapping(value={"/download"})
    @PreAuthorize(value="@el.check('dept:list')")
    public void exportDept(HttpServletResponse response, DeptQueryCriteria criteria) throws Exception {
        this.deptService.download(this.deptService.queryAll(criteria, Boolean.valueOf(false)), response);
    }

    @ApiOperation(value="\u67e5\u8be2\u90e8\u95e8")
    @GetMapping
    @PreAuthorize(value="@el.check('user:list','dept:list')")
    public ResponseEntity<Object> queryDept(DeptQueryCriteria criteria) throws Exception {
        List deptDtos = this.deptService.queryAll(criteria, Boolean.valueOf(true));
        return new ResponseEntity((Object)PageUtil.toPage((Object)deptDtos, (Object)deptDtos.size()), HttpStatus.OK);
    }

    @ApiOperation(value="\u67e5\u8be2\u90e8\u95e8:\u6839\u636eID\u83b7\u53d6\u540c\u7ea7\u4e0e\u4e0a\u7ea7\u6570\u636e")
    @PostMapping(value={"/superior"})
    @PreAuthorize(value="@el.check('user:list','dept:list')")
    public ResponseEntity<Object> getDeptSuperior(@RequestBody List<Long> ids) {
        LinkedHashSet deptDtos = new LinkedHashSet();
        for (Long id : ids) {
            DeptDto deptDto = this.deptService.findById(id);
            List depts = this.deptService.getSuperior(deptDto, new ArrayList());
            deptDtos.addAll(depts);
        }
        return new ResponseEntity(this.deptService.buildTree(new ArrayList(deptDtos)), HttpStatus.OK);
    }

    @Log(value="\u65b0\u589e\u90e8\u95e8")
    @ApiOperation(value="\u65b0\u589e\u90e8\u95e8")
    @PostMapping
    @PreAuthorize(value="@el.check('dept:add')")
    public ResponseEntity<Object> createDept(@Validated @RequestBody Dept resources) {
        if (resources.getId() != null) {
            throw new BadRequestException("A new dept cannot already have an ID");
        }
        this.deptService.create(resources);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Log(value="\u4fee\u6539\u90e8\u95e8")
    @ApiOperation(value="\u4fee\u6539\u90e8\u95e8")
    @PutMapping
    @PreAuthorize(value="@el.check('dept:edit')")
    public ResponseEntity<Object> updateDept(@Validated(value={BaseEntity.Update.class}) @RequestBody Dept resources) {
        this.deptService.update(resources);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Log(value="\u5220\u9664\u90e8\u95e8")
    @ApiOperation(value="\u5220\u9664\u90e8\u95e8")
    @DeleteMapping
    @PreAuthorize(value="@el.check('dept:del')")
    public ResponseEntity<Object> deleteDept(@RequestBody Set<Long> ids) {
        Set<Object> deptDtos = new HashSet<DeptDto>();
        for (Long id : ids) {
            List deptList = this.deptService.findByPid(id.longValue());
            deptDtos.add(this.deptService.findById(id));
            if (!CollectionUtil.isNotEmpty((Collection)deptList)) continue;
            deptDtos = this.deptService.getDeleteDepts(deptList, deptDtos);
        }
        this.deptService.verification(deptDtos);
        this.deptService.delete(deptDtos);
        return new ResponseEntity(HttpStatus.OK);
    }

    public DeptController(DeptService deptService) {
        this.deptService = deptService;
    }
}

