/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.quartz.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.quartz.domain.QuartzJob;
import me.zhengjie.modules.quartz.domain.QuartzLog;
import me.zhengjie.modules.quartz.repository.QuartzJobRepository;
import me.zhengjie.modules.quartz.repository.QuartzLogRepository;
import me.zhengjie.modules.quartz.service.QuartzJobService;
import me.zhengjie.modules.quartz.service.dto.JobQueryCriteria;
import me.zhengjie.modules.quartz.utils.QuartzManage;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.StringUtils;
import me.zhengjie.utils.ValidationUtil;
import org.quartz.CronExpression;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="quartzJobService")
public class QuartzJobServiceImpl
implements QuartzJobService {
    private final QuartzJobRepository quartzJobRepository;
    private final QuartzLogRepository quartzLogRepository;
    private final QuartzManage quartzManage;
    private final RedisUtils redisUtils;

    public Object queryAll(JobQueryCriteria criteria, Pageable pageable) {
        return PageUtil.toPage((Page)this.quartzJobRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), pageable));
    }

    public Object queryAllLog(JobQueryCriteria criteria, Pageable pageable) {
        return PageUtil.toPage((Page)this.quartzLogRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), pageable));
    }

    public List<QuartzJob> queryAll(JobQueryCriteria criteria) {
        return this.quartzJobRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder));
    }

    public List<QuartzLog> queryAllLog(JobQueryCriteria criteria) {
        return this.quartzLogRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder));
    }

    public QuartzJob findById(Long id) {
        QuartzJob quartzJob = this.quartzJobRepository.findById((Object)id).orElseGet(QuartzJob::new);
        ValidationUtil.isNull((Object)quartzJob.getId(), (String)"QuartzJob", (String)"id", (Object)id);
        return quartzJob;
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(QuartzJob resources) {
        if (!CronExpression.isValidExpression((String)resources.getCronExpression())) {
            throw new BadRequestException("cron\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef");
        }
        resources = (QuartzJob)this.quartzJobRepository.save((Object)resources);
        this.quartzManage.addJob(resources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(QuartzJob resources) {
        List<String> tasks;
        if (!CronExpression.isValidExpression((String)resources.getCronExpression())) {
            throw new BadRequestException("cron\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((CharSequence)resources.getSubTask()) && (tasks = Arrays.asList(resources.getSubTask().split("[,\uff0c]"))).contains(resources.getId().toString())) {
            throw new BadRequestException("\u5b50\u4efb\u52a1\u4e2d\u4e0d\u80fd\u6dfb\u52a0\u5f53\u524d\u4efb\u52a1ID");
        }
        resources = (QuartzJob)this.quartzJobRepository.save((Object)resources);
        this.quartzManage.updateJobCron(resources);
    }

    public void updateIsPause(QuartzJob quartzJob) {
        if (quartzJob.getIsPause().booleanValue()) {
            this.quartzManage.resumeJob(quartzJob);
            quartzJob.setIsPause(Boolean.valueOf(false));
        } else {
            this.quartzManage.pauseJob(quartzJob);
            quartzJob.setIsPause(Boolean.valueOf(true));
        }
        this.quartzJobRepository.save((Object)quartzJob);
    }

    public void execution(QuartzJob quartzJob) {
        this.quartzManage.runJobNow(quartzJob);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<Long> ids) {
        for (Long id : ids) {
            QuartzJob quartzJob = this.findById(id);
            this.quartzManage.deleteJob(quartzJob);
            this.quartzJobRepository.delete((Object)quartzJob);
        }
    }

    @Async
    @Transactional(rollbackFor={Exception.class})
    public void executionSubJob(String[] tasks) throws InterruptedException {
        for (String id : tasks) {
            if (StrUtil.isBlank((CharSequence)id)) continue;
            QuartzJob quartzJob = this.findById(Long.valueOf(Long.parseLong(id)));
            String uuid = IdUtil.simpleUUID();
            quartzJob.setUuid(uuid);
            this.execution(quartzJob);
            Boolean result = (Boolean)this.redisUtils.get(uuid);
            while (result == null) {
                Thread.sleep(5000L);
                result = (Boolean)this.redisUtils.get(uuid);
            }
            if (result.booleanValue()) continue;
            this.redisUtils.del(new String[]{uuid});
            break;
        }
    }

    public void download(List<QuartzJob> quartzJobs, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (QuartzJob quartzJob : quartzJobs) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u4efb\u52a1\u540d\u79f0", quartzJob.getJobName());
            map.put("Bean\u540d\u79f0", quartzJob.getBeanName());
            map.put("\u6267\u884c\u65b9\u6cd5", quartzJob.getMethodName());
            map.put("\u53c2\u6570", quartzJob.getParams());
            map.put("\u8868\u8fbe\u5f0f", quartzJob.getCronExpression());
            map.put("\u72b6\u6001", quartzJob.getIsPause() != false ? "\u6682\u505c\u4e2d" : "\u8fd0\u884c\u4e2d");
            map.put("\u63cf\u8ff0", quartzJob.getDescription());
            map.put("\u521b\u5efa\u65e5\u671f", quartzJob.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public void downloadLog(List<QuartzLog> queryAllLog, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (QuartzLog quartzLog : queryAllLog) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u4efb\u52a1\u540d\u79f0", quartzLog.getJobName());
            map.put("Bean\u540d\u79f0", quartzLog.getBeanName());
            map.put("\u6267\u884c\u65b9\u6cd5", quartzLog.getMethodName());
            map.put("\u53c2\u6570", quartzLog.getParams());
            map.put("\u8868\u8fbe\u5f0f", quartzLog.getCronExpression());
            map.put("\u5f02\u5e38\u8be6\u60c5", quartzLog.getExceptionDetail());
            map.put("\u8017\u65f6/\u6beb\u79d2", quartzLog.getTime());
            map.put("\u72b6\u6001", quartzLog.getIsSuccess() != false ? "\u6210\u529f" : "\u5931\u8d25");
            map.put("\u521b\u5efa\u65e5\u671f", quartzLog.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public QuartzJobServiceImpl(QuartzJobRepository quartzJobRepository, QuartzLogRepository quartzLogRepository, QuartzManage quartzManage, RedisUtils redisUtils) {
        this.quartzJobRepository = quartzJobRepository;
        this.quartzLogRepository = quartzLogRepository;
        this.quartzManage = quartzManage;
        this.redisUtils = redisUtils;
    }
}

