/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.security.service;

import me.zhengjie.exception.BadRequestException;
import me.zhengjie.exception.EntityNotFoundException;
import me.zhengjie.modules.security.service.UserCacheManager;
import me.zhengjie.modules.security.service.dto.JwtUserDto;
import me.zhengjie.modules.system.service.DataService;
import me.zhengjie.modules.system.service.RoleService;
import me.zhengjie.modules.system.service.UserService;
import me.zhengjie.modules.system.service.dto.UserDto;
import me.zhengjie.modules.system.service.dto.UserLoginDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="userDetailsService")
public class UserDetailsServiceImpl
implements UserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(UserDetailsServiceImpl.class);
    private final UserService userService;
    private final RoleService roleService;
    private final DataService dataService;
    private final UserCacheManager userCacheManager;

    public JwtUserDto loadUserByUsername(String username) {
        JwtUserDto jwtUserDto = this.userCacheManager.getUserCache(username);
        if (jwtUserDto == null) {
            UserLoginDto user;
            try {
                user = this.userService.getLoginData(username);
            }
            catch (EntityNotFoundException e) {
                throw new UsernameNotFoundException(username, (Throwable)e);
            }
            if (user == null) {
                throw new UsernameNotFoundException("");
            }
            if (!user.getEnabled().booleanValue()) {
                throw new BadRequestException("\u8d26\u53f7\u672a\u6fc0\u6d3b\uff01");
            }
            jwtUserDto = new JwtUserDto(user, this.dataService.getDeptIds((UserDto)user), this.roleService.mapToGrantedAuthorities((UserDto)user));
            this.userCacheManager.addUserCache(username, jwtUserDto);
        }
        return jwtUserDto;
    }

    public UserDetailsServiceImpl(UserService userService, RoleService roleService, DataService dataService, UserCacheManager userCacheManager) {
        this.userService = userService;
        this.roleService = roleService;
        this.dataService = dataService;
        this.userCacheManager = userCacheManager;
    }
}

