/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.security.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.Filter;
import me.zhengjie.annotation.AnonymousAccess;
import me.zhengjie.modules.security.config.SpringSecurityConfig;
import me.zhengjie.modules.security.config.bean.SecurityProperties;
import me.zhengjie.modules.security.security.JwtAccessDeniedHandler;
import me.zhengjie.modules.security.security.JwtAuthenticationEntryPoint;
import me.zhengjie.modules.security.security.TokenConfigurer;
import me.zhengjie.modules.security.security.TokenProvider;
import me.zhengjie.modules.security.service.OnlineUserService;
import me.zhengjie.modules.security.service.UserCacheManager;
import me.zhengjie.utils.enums.RequestMethodEnum;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
public class SpringSecurityConfig
extends WebSecurityConfigurerAdapter {
    private final TokenProvider tokenProvider;
    private final CorsFilter corsFilter;
    private final JwtAuthenticationEntryPoint authenticationErrorHandler;
    private final JwtAccessDeniedHandler jwtAccessDeniedHandler;
    private final ApplicationContext applicationContext;
    private final SecurityProperties properties;
    private final OnlineUserService onlineUserService;
    private final UserCacheManager userCacheManager;

    @Bean
    GrantedAuthorityDefaults grantedAuthorityDefaults() {
        return new GrantedAuthorityDefaults("");
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    protected void configure(HttpSecurity httpSecurity) throws Exception {
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)this.applicationContext.getBean("requestMappingHandlerMapping");
        Map handlerMethodMap = requestMappingHandlerMapping.getHandlerMethods();
        Map anonymousUrls = this.getAnonymousUrl(handlerMethodMap);
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)httpSecurity.csrf().disable()).addFilterBefore((Filter)this.corsFilter, UsernamePasswordAuthenticationFilter.class).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationErrorHandler).accessDeniedHandler((AccessDeniedHandler)this.jwtAccessDeniedHandler).and()).headers().frameOptions().disable().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/*.html", "/**/*.html", "/**/*.css", "/**/*.js", "/webSocket/**"})).permitAll().antMatchers(new String[]{"/swagger-ui.html"})).permitAll().antMatchers(new String[]{"/swagger-resources/**"})).permitAll().antMatchers(new String[]{"/webjars/**"})).permitAll().antMatchers(new String[]{"/*/api-docs"})).permitAll().antMatchers(new String[]{"/avatar/**"})).permitAll().antMatchers(new String[]{"/file/**"})).permitAll().antMatchers(new String[]{"/druid/**"})).permitAll().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().antMatchers(HttpMethod.GET, ((Set)anonymousUrls.get(RequestMethodEnum.GET.getType())).toArray(new String[0]))).permitAll().antMatchers(HttpMethod.POST, ((Set)anonymousUrls.get(RequestMethodEnum.POST.getType())).toArray(new String[0]))).permitAll().antMatchers(HttpMethod.PUT, ((Set)anonymousUrls.get(RequestMethodEnum.PUT.getType())).toArray(new String[0]))).permitAll().antMatchers(HttpMethod.PATCH, ((Set)anonymousUrls.get(RequestMethodEnum.PATCH.getType())).toArray(new String[0]))).permitAll().antMatchers(HttpMethod.DELETE, ((Set)anonymousUrls.get(RequestMethodEnum.DELETE.getType())).toArray(new String[0]))).permitAll().antMatchers(((Set)anonymousUrls.get(RequestMethodEnum.ALL.getType())).toArray(new String[0]))).permitAll().and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
    }

    private TokenConfigurer securityConfigurerAdapter() {
        return new TokenConfigurer(this.tokenProvider, this.properties, this.onlineUserService, this.userCacheManager);
    }

    private Map<String, Set<String>> getAnonymousUrl(Map<RequestMappingInfo, HandlerMethod> handlerMethodMap) {
        HashMap<String, Set<String>> anonymousUrls = new HashMap<String, Set<String>>(8);
        HashSet get = new HashSet();
        HashSet post = new HashSet();
        HashSet put = new HashSet();
        HashSet patch = new HashSet();
        HashSet delete = new HashSet();
        HashSet all = new HashSet();
        block7: for (Map.Entry<RequestMappingInfo, HandlerMethod> infoEntry : handlerMethodMap.entrySet()) {
            HandlerMethod handlerMethod = infoEntry.getValue();
            AnonymousAccess anonymousAccess = (AnonymousAccess)handlerMethod.getMethodAnnotation(AnonymousAccess.class);
            if (null == anonymousAccess) continue;
            ArrayList requestMethods = new ArrayList(infoEntry.getKey().getMethodsCondition().getMethods());
            RequestMethodEnum request = RequestMethodEnum.find((String)(requestMethods.size() == 0 ? RequestMethodEnum.ALL.getType() : ((RequestMethod)requestMethods.get(0)).name()));
            switch (1.$SwitchMap$me$zhengjie$utils$enums$RequestMethodEnum[Objects.requireNonNull(request).ordinal()]) {
                case 1: {
                    get.addAll(infoEntry.getKey().getPatternsCondition().getPatterns());
                    continue block7;
                }
                case 2: {
                    post.addAll(infoEntry.getKey().getPatternsCondition().getPatterns());
                    continue block7;
                }
                case 3: {
                    put.addAll(infoEntry.getKey().getPatternsCondition().getPatterns());
                    continue block7;
                }
                case 4: {
                    patch.addAll(infoEntry.getKey().getPatternsCondition().getPatterns());
                    continue block7;
                }
                case 5: {
                    delete.addAll(infoEntry.getKey().getPatternsCondition().getPatterns());
                    continue block7;
                }
            }
            all.addAll(infoEntry.getKey().getPatternsCondition().getPatterns());
        }
        anonymousUrls.put(RequestMethodEnum.GET.getType(), get);
        anonymousUrls.put(RequestMethodEnum.POST.getType(), post);
        anonymousUrls.put(RequestMethodEnum.PUT.getType(), put);
        anonymousUrls.put(RequestMethodEnum.PATCH.getType(), patch);
        anonymousUrls.put(RequestMethodEnum.DELETE.getType(), delete);
        anonymousUrls.put(RequestMethodEnum.ALL.getType(), all);
        return anonymousUrls;
    }

    public SpringSecurityConfig(TokenProvider tokenProvider, CorsFilter corsFilter, JwtAuthenticationEntryPoint authenticationErrorHandler, JwtAccessDeniedHandler jwtAccessDeniedHandler, ApplicationContext applicationContext, SecurityProperties properties, OnlineUserService onlineUserService, UserCacheManager userCacheManager) {
        this.tokenProvider = tokenProvider;
        this.corsFilter = corsFilter;
        this.authenticationErrorHandler = authenticationErrorHandler;
        this.jwtAccessDeniedHandler = jwtAccessDeniedHandler;
        this.applicationContext = applicationContext;
        this.properties = properties;
        this.onlineUserService = onlineUserService;
        this.userCacheManager = userCacheManager;
    }
}

