/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import me.zhengjie.config.FileProperties;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.exception.EntityExistException;
import me.zhengjie.exception.EntityNotFoundException;
import me.zhengjie.modules.security.service.OnlineUserService;
import me.zhengjie.modules.security.service.UserCacheManager;
import me.zhengjie.modules.system.domain.User;
import me.zhengjie.modules.system.repository.UserRepository;
import me.zhengjie.modules.system.service.UserService;
import me.zhengjie.modules.system.service.dto.JobSmallDto;
import me.zhengjie.modules.system.service.dto.RoleSmallDto;
import me.zhengjie.modules.system.service.dto.UserDto;
import me.zhengjie.modules.system.service.dto.UserLoginDto;
import me.zhengjie.modules.system.service.dto.UserQueryCriteria;
import me.zhengjie.modules.system.service.mapstruct.UserLoginMapper;
import me.zhengjie.modules.system.service.mapstruct.UserMapper;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.SecurityUtils;
import me.zhengjie.utils.StringUtils;
import me.zhengjie.utils.ValidationUtil;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@CacheConfig(cacheNames={"user"})
public class UserServiceImpl
implements UserService {
    private final UserRepository userRepository;
    private final UserMapper userMapper;
    private final FileProperties properties;
    private final RedisUtils redisUtils;
    private final UserCacheManager userCacheManager;
    private final OnlineUserService onlineUserService;
    private final UserLoginMapper userLoginMapper;

    public Object queryAll(UserQueryCriteria criteria, Pageable pageable) {
        Page page = this.userRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), pageable);
        return PageUtil.toPage((Page)page.map(arg_0 -> ((UserMapper)this.userMapper).toDto(arg_0)));
    }

    public List<UserDto> queryAll(UserQueryCriteria criteria) {
        List users = this.userRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder));
        return this.userMapper.toDto(users);
    }

    @Cacheable(key="'id:' + #p0")
    @Transactional(rollbackFor={Exception.class})
    public UserDto findById(long id) {
        User user = this.userRepository.findById((Object)id).orElseGet(User::new);
        ValidationUtil.isNull((Object)user.getId(), (String)"User", (String)"id", (Object)id);
        return (UserDto)this.userMapper.toDto((Object)user);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(User resources) {
        if (this.userRepository.findByUsername(resources.getUsername()) != null) {
            throw new EntityExistException(User.class, "username", resources.getUsername());
        }
        if (this.userRepository.findByEmail(resources.getEmail()) != null) {
            throw new EntityExistException(User.class, "email", resources.getEmail());
        }
        if (this.userRepository.findByPhone(resources.getPhone()) != null) {
            throw new EntityExistException(User.class, "phone", resources.getPhone());
        }
        this.userRepository.save((Object)resources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(User resources) throws Exception {
        User user = this.userRepository.findById((Object)resources.getId()).orElseGet(User::new);
        ValidationUtil.isNull((Object)user.getId(), (String)"User", (String)"id", (Object)resources.getId());
        User user1 = this.userRepository.findByUsername(resources.getUsername());
        User user2 = this.userRepository.findByEmail(resources.getEmail());
        User user3 = this.userRepository.findByPhone(resources.getPhone());
        if (user1 != null && !user.getId().equals(user1.getId())) {
            throw new EntityExistException(User.class, "username", resources.getUsername());
        }
        if (user2 != null && !user.getId().equals(user2.getId())) {
            throw new EntityExistException(User.class, "email", resources.getEmail());
        }
        if (user3 != null && !user.getId().equals(user3.getId())) {
            throw new EntityExistException(User.class, "phone", resources.getPhone());
        }
        if (!resources.getRoles().equals(user.getRoles())) {
            this.redisUtils.del(new String[]{"data::user:" + resources.getId()});
            this.redisUtils.del(new String[]{"menu::user:" + resources.getId()});
            this.redisUtils.del(new String[]{"role::auth:" + resources.getId()});
        }
        if (!Objects.equals(resources.getDept(), user.getDept())) {
            this.redisUtils.del(new String[]{"data::user:" + resources.getId()});
        }
        if (!resources.getEnabled().booleanValue()) {
            this.onlineUserService.kickOutForUsername(resources.getUsername());
        }
        user.setUsername(resources.getUsername());
        user.setEmail(resources.getEmail());
        user.setEnabled(resources.getEnabled());
        user.setRoles(resources.getRoles());
        user.setDept(resources.getDept());
        user.setJobs(resources.getJobs());
        user.setPhone(resources.getPhone());
        user.setNickName(resources.getNickName());
        user.setGender(resources.getGender());
        this.userRepository.save((Object)user);
        this.delCaches(user.getId(), user.getUsername());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCenter(User resources) {
        User user = this.userRepository.findById((Object)resources.getId()).orElseGet(User::new);
        User user1 = this.userRepository.findByPhone(resources.getPhone());
        if (user1 != null && !user.getId().equals(user1.getId())) {
            throw new EntityExistException(User.class, "phone", resources.getPhone());
        }
        user.setNickName(resources.getNickName());
        user.setPhone(resources.getPhone());
        user.setGender(resources.getGender());
        this.userRepository.save((Object)user);
        this.delCaches(user.getId(), user.getUsername());
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<Long> ids) {
        for (Long id : ids) {
            UserDto user = this.findById(id.longValue());
            this.delCaches(user.getId(), user.getUsername());
        }
        this.userRepository.deleteAllByIdIn(ids);
    }

    public UserDto findByName(String userName) {
        User user = this.userRepository.findByUsername(userName);
        if (user == null) {
            throw new EntityNotFoundException(User.class, "name", userName);
        }
        return (UserDto)this.userMapper.toDto((Object)user);
    }

    public UserLoginDto getLoginData(String userName) {
        User user = this.userRepository.findByUsername(userName);
        if (user == null) {
            throw new EntityNotFoundException(User.class, "name", userName);
        }
        return (UserLoginDto)this.userLoginMapper.toDto((Object)user);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePass(String username, String pass) {
        this.userRepository.updatePass(username, pass, new Date());
        this.flushCache(username);
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, String> updateAvatar(MultipartFile multipartFile) {
        FileUtil.checkSize((long)this.properties.getAvatarMaxSize(), (long)multipartFile.getSize());
        String image = "gif jpg png jpeg";
        String fileType = FileUtil.getExtensionName((String)multipartFile.getOriginalFilename());
        if (fileType != null && !image.contains(fileType)) {
            throw new BadRequestException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01, \u4ec5\u652f\u6301 " + image + " \u683c\u5f0f");
        }
        User user = this.userRepository.findByUsername(SecurityUtils.getCurrentUsername());
        String oldPath = user.getAvatarPath();
        File file = FileUtil.upload((MultipartFile)multipartFile, (String)this.properties.getPath().getAvatar());
        user.setAvatarPath(Objects.requireNonNull(file).getPath());
        user.setAvatarName(file.getName());
        this.userRepository.save((Object)user);
        if (StringUtils.isNotBlank((CharSequence)oldPath)) {
            FileUtil.del((String)oldPath);
        }
        @NotBlank String username = user.getUsername();
        this.flushCache(username);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateEmail(String username, String email) {
        this.userRepository.updateEmail(username, email);
        this.flushCache(username);
    }

    public void download(List<UserDto> queryAll, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (UserDto userDTO : queryAll) {
            List roles = userDTO.getRoles().stream().map(RoleSmallDto::getName).collect(Collectors.toList());
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u7528\u6237\u540d", userDTO.getUsername());
            map.put("\u89d2\u8272", roles);
            map.put("\u90e8\u95e8", userDTO.getDept().getName());
            map.put("\u5c97\u4f4d", userDTO.getJobs().stream().map(JobSmallDto::getName).collect(Collectors.toList()));
            map.put("\u90ae\u7bb1", userDTO.getEmail());
            map.put("\u72b6\u6001", userDTO.getEnabled() != false ? "\u542f\u7528" : "\u7981\u7528");
            map.put("\u624b\u673a\u53f7\u7801", userDTO.getPhone());
            map.put("\u4fee\u6539\u5bc6\u7801\u7684\u65f6\u95f4", userDTO.getPwdResetTime());
            map.put("\u521b\u5efa\u65e5\u671f", userDTO.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public void delCaches(Long id, String username) {
        this.redisUtils.del(new String[]{"user::id:" + id});
        this.flushCache(username);
    }

    private void flushCache(String username) {
        this.userCacheManager.cleanUserCache(username);
    }

    public UserServiceImpl(UserRepository userRepository, UserMapper userMapper, FileProperties properties, RedisUtils redisUtils, UserCacheManager userCacheManager, OnlineUserService onlineUserService, UserLoginMapper userLoginMapper) {
        this.userRepository = userRepository;
        this.userMapper = userMapper;
        this.properties = properties;
        this.redisUtils = redisUtils;
        this.userCacheManager = userCacheManager;
        this.onlineUserService = onlineUserService;
        this.userLoginMapper = userLoginMapper;
    }
}

