/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.security.config.bean;

import com.wf.captcha.ChineseCaptcha;
import com.wf.captcha.ChineseGifCaptcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import java.awt.Font;
import java.util.Objects;
import me.zhengjie.exception.BadConfigurationException;
import me.zhengjie.modules.security.config.bean.LoginCode;
import me.zhengjie.modules.security.config.bean.LoginCodeEnum;
import me.zhengjie.modules.security.config.bean.LoginProperties;
import me.zhengjie.utils.StringUtils;

public class LoginProperties {
    private boolean singleLogin = false;
    private LoginCode loginCode;
    public static final String cacheKey = "USER-LOGIN-DATA";

    public boolean isSingleLogin() {
        return this.singleLogin;
    }

    public Captcha getCaptcha() {
        if (Objects.isNull(this.loginCode)) {
            this.loginCode = new LoginCode();
            if (Objects.isNull(this.loginCode.getCodeType())) {
                this.loginCode.setCodeType(LoginCodeEnum.ARITHMETIC);
            }
        }
        return this.switchCaptcha(this.loginCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Captcha switchCaptcha(LoginCode loginCode) {
        FixedArithmeticCaptcha captcha;
        LoginProperties loginProperties = this;
        synchronized (loginProperties) {
            switch (1.$SwitchMap$me$zhengjie$modules$security$config$bean$LoginCodeEnum[loginCode.getCodeType().ordinal()]) {
                case 1: {
                    captcha = new FixedArithmeticCaptcha(loginCode.getWidth(), loginCode.getHeight());
                    captcha.setLen(loginCode.getLength());
                    break;
                }
                case 2: {
                    captcha = new ChineseCaptcha(loginCode.getWidth(), loginCode.getHeight());
                    captcha.setLen(loginCode.getLength());
                    break;
                }
                case 3: {
                    captcha = new ChineseGifCaptcha(loginCode.getWidth(), loginCode.getHeight());
                    captcha.setLen(loginCode.getLength());
                    break;
                }
                case 4: {
                    captcha = new GifCaptcha(loginCode.getWidth(), loginCode.getHeight());
                    captcha.setLen(loginCode.getLength());
                    break;
                }
                case 5: {
                    captcha = new SpecCaptcha(loginCode.getWidth(), loginCode.getHeight());
                    captcha.setLen(loginCode.getLength());
                    break;
                }
                default: {
                    throw new BadConfigurationException("\u9a8c\u8bc1\u7801\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff01\u6b63\u786e\u914d\u7f6e\u67e5\u770b LoginCodeEnum ");
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)loginCode.getFontName())) {
            captcha.setFont(new Font(loginCode.getFontName(), 0, loginCode.getFontSize()));
        }
        return captcha;
    }

    public LoginCode getLoginCode() {
        return this.loginCode;
    }

    public void setSingleLogin(boolean singleLogin) {
        this.singleLogin = singleLogin;
    }

    public void setLoginCode(LoginCode loginCode) {
        this.loginCode = loginCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginProperties)) {
            return false;
        }
        LoginProperties other = (LoginProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSingleLogin() != other.isSingleLogin()) {
            return false;
        }
        LoginCode this$loginCode = this.getLoginCode();
        LoginCode other$loginCode = other.getLoginCode();
        return !(this$loginCode == null ? other$loginCode != null : !this$loginCode.equals(other$loginCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSingleLogin() ? 79 : 97);
        LoginCode $loginCode = this.getLoginCode();
        result = result * 59 + ($loginCode == null ? 43 : $loginCode.hashCode());
        return result;
    }

    public String toString() {
        return "LoginProperties(singleLogin=" + this.isSingleLogin() + ", loginCode=" + this.getLoginCode() + ")";
    }
}

