/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.service.mapstruct;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.zhengjie.modules.system.domain.Dept;
import me.zhengjie.modules.system.domain.Menu;
import me.zhengjie.modules.system.domain.Role;
import me.zhengjie.modules.system.service.dto.DeptDto;
import me.zhengjie.modules.system.service.dto.MenuDto;
import me.zhengjie.modules.system.service.dto.RoleDto;
import me.zhengjie.modules.system.service.mapstruct.DeptMapper;
import me.zhengjie.modules.system.service.mapstruct.MenuMapper;
import me.zhengjie.modules.system.service.mapstruct.RoleMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleMapperImpl
implements RoleMapper {
    @Autowired
    private MenuMapper menuMapper;
    @Autowired
    private DeptMapper deptMapper;

    public Role toEntity(RoleDto dto) {
        if (dto == null) {
            return null;
        }
        Role role = new Role();
        role.setCreateBy(dto.getCreateBy());
        role.setUpdateBy(dto.getUpdateBy());
        role.setCreateTime(dto.getCreateTime());
        role.setUpdateTime(dto.getUpdateTime());
        role.setId(dto.getId());
        role.setMenus(this.menuDtoSetToMenuSet(dto.getMenus()));
        role.setDepts(this.deptDtoSetToDeptSet(dto.getDepts()));
        role.setName(dto.getName());
        role.setDataScope(dto.getDataScope());
        role.setLevel(dto.getLevel());
        role.setDescription(dto.getDescription());
        return role;
    }

    public RoleDto toDto(Role entity) {
        if (entity == null) {
            return null;
        }
        RoleDto roleDto = new RoleDto();
        roleDto.setCreateBy(entity.getCreateBy());
        roleDto.setUpdateBy(entity.getUpdateBy());
        roleDto.setCreateTime(entity.getCreateTime());
        roleDto.setUpdateTime(entity.getUpdateTime());
        roleDto.setId(entity.getId());
        roleDto.setMenus(this.menuSetToMenuDtoSet(entity.getMenus()));
        roleDto.setDepts(this.deptSetToDeptDtoSet(entity.getDepts()));
        roleDto.setName(entity.getName());
        roleDto.setDataScope(entity.getDataScope());
        roleDto.setLevel(entity.getLevel());
        roleDto.setDescription(entity.getDescription());
        return roleDto;
    }

    public List<Role> toEntity(List<RoleDto> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<Role> list = new ArrayList<Role>(dtoList.size());
        for (RoleDto roleDto : dtoList) {
            list.add(this.toEntity(roleDto));
        }
        return list;
    }

    public List<RoleDto> toDto(List<Role> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<RoleDto> list = new ArrayList<RoleDto>(entityList.size());
        for (Role role : entityList) {
            list.add(this.toDto(role));
        }
        return list;
    }

    protected Set<Menu> menuDtoSetToMenuSet(Set<MenuDto> set) {
        if (set == null) {
            return null;
        }
        HashSet<Menu> set1 = new HashSet<Menu>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (MenuDto menuDto : set) {
            set1.add((Menu)this.menuMapper.toEntity((Object)menuDto));
        }
        return set1;
    }

    protected Set<Dept> deptDtoSetToDeptSet(Set<DeptDto> set) {
        if (set == null) {
            return null;
        }
        HashSet<Dept> set1 = new HashSet<Dept>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (DeptDto deptDto : set) {
            set1.add((Dept)this.deptMapper.toEntity((Object)deptDto));
        }
        return set1;
    }

    protected Set<MenuDto> menuSetToMenuDtoSet(Set<Menu> set) {
        if (set == null) {
            return null;
        }
        HashSet<MenuDto> set1 = new HashSet<MenuDto>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (Menu menu : set) {
            set1.add((MenuDto)this.menuMapper.toDto((Object)menu));
        }
        return set1;
    }

    protected Set<DeptDto> deptSetToDeptDtoSet(Set<Dept> set) {
        if (set == null) {
            return null;
        }
        HashSet<DeptDto> set1 = new HashSet<DeptDto>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (Dept dept : set) {
            set1.add((DeptDto)this.deptMapper.toDto((Object)dept));
        }
        return set1;
    }
}

