/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import me.zhengjie.domain.vo.EmailVo;
import me.zhengjie.modules.system.rest.VerifyController;
import me.zhengjie.modules.system.service.VerifyService;
import me.zhengjie.service.EmailService;
import me.zhengjie.utils.enums.CodeBiEnum;
import me.zhengjie.utils.enums.CodeEnum;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/code"})
@Api(tags={"\u7cfb\u7edf\uff1a\u9a8c\u8bc1\u7801\u7ba1\u7406"})
public class VerifyController {
    private final VerifyService verificationCodeService;
    private final EmailService emailService;

    @PostMapping(value={"/resetEmail"})
    @ApiOperation(value="\u91cd\u7f6e\u90ae\u7bb1\uff0c\u53d1\u9001\u9a8c\u8bc1\u7801")
    public ResponseEntity<Object> resetEmail(@RequestParam String email) {
        EmailVo emailVo = this.verificationCodeService.sendEmail(email, CodeEnum.EMAIL_RESET_EMAIL_CODE.getKey());
        this.emailService.send(emailVo, this.emailService.find());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/email/resetPass"})
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801\uff0c\u53d1\u9001\u9a8c\u8bc1\u7801")
    public ResponseEntity<Object> resetPass(@RequestParam String email) {
        EmailVo emailVo = this.verificationCodeService.sendEmail(email, CodeEnum.EMAIL_RESET_PWD_CODE.getKey());
        this.emailService.send(emailVo, this.emailService.find());
        return new ResponseEntity(HttpStatus.OK);
    }

    @GetMapping(value={"/validated"})
    @ApiOperation(value="\u9a8c\u8bc1\u7801\u9a8c\u8bc1")
    public ResponseEntity<Object> validated(@RequestParam String email, @RequestParam String code, @RequestParam Integer codeBi) {
        CodeBiEnum biEnum = CodeBiEnum.find((Integer)codeBi);
        switch (1.$SwitchMap$me$zhengjie$utils$enums$CodeBiEnum[Objects.requireNonNull(biEnum).ordinal()]) {
            case 1: {
                this.verificationCodeService.validated(CodeEnum.EMAIL_RESET_EMAIL_CODE.getKey() + email, code);
                break;
            }
            case 2: {
                this.verificationCodeService.validated(CodeEnum.EMAIL_RESET_PWD_CODE.getKey() + email, code);
                break;
            }
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    public VerifyController(VerifyService verificationCodeService, EmailService emailService) {
        this.verificationCodeService = verificationCodeService;
        this.emailService = emailService;
    }
}

