/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.security.security;

import cn.hutool.core.util.StrUtil;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import me.zhengjie.modules.security.config.bean.SecurityProperties;
import me.zhengjie.modules.security.security.TokenProvider;
import me.zhengjie.modules.security.service.OnlineUserService;
import me.zhengjie.modules.security.service.UserCacheManager;
import me.zhengjie.modules.security.service.dto.OnlineUserDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class TokenFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(TokenFilter.class);
    private final TokenProvider tokenProvider;
    private final SecurityProperties properties;
    private final OnlineUserService onlineUserService;
    private final UserCacheManager userCacheManager;

    public TokenFilter(TokenProvider tokenProvider, SecurityProperties properties, OnlineUserService onlineUserService, UserCacheManager userCacheManager) {
        this.properties = properties;
        this.onlineUserService = onlineUserService;
        this.tokenProvider = tokenProvider;
        this.userCacheManager = userCacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String token = this.resolveToken(httpServletRequest);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            OnlineUserDto onlineUserDto = null;
            boolean cleanUserCache = false;
            try {
                onlineUserDto = this.onlineUserService.getOne(this.properties.getOnlineKey() + token);
            }
            catch (ExpiredJwtException e) {
                log.error(e.getMessage());
                cleanUserCache = true;
            }
            finally {
                if (cleanUserCache || Objects.isNull(onlineUserDto)) {
                    this.userCacheManager.cleanUserCache(String.valueOf(this.tokenProvider.getClaims(token).get((Object)"user")));
                }
            }
            if (onlineUserDto != null && StringUtils.hasText((String)token)) {
                Authentication authentication = this.tokenProvider.getAuthentication(token);
                SecurityContextHolder.getContext().setAuthentication(authentication);
                this.tokenProvider.checkRenewal(token);
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private String resolveToken(HttpServletRequest request) {
        String bearerToken = request.getHeader(this.properties.getHeader());
        if (StringUtils.hasText((String)bearerToken) && bearerToken.startsWith(this.properties.getTokenStartWith())) {
            return bearerToken.replace(this.properties.getTokenStartWith(), "");
        }
        log.debug("\u975e\u6cd5Token\uff1a{}", (Object)bearerToken);
        return null;
    }
}

