/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.annotation.Log;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.mnt.domain.Database;
import me.zhengjie.modules.mnt.service.DatabaseService;
import me.zhengjie.modules.mnt.service.dto.DatabaseDto;
import me.zhengjie.modules.mnt.service.dto.DatabaseQueryCriteria;
import me.zhengjie.modules.mnt.util.SqlUtils;
import me.zhengjie.utils.FileUtil;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8fd0\u7ef4\uff1a\u6570\u636e\u5e93\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/database"})
public class DatabaseController {
    private final String fileSavePath = FileUtil.getTmpDirPath() + "/";
    private final DatabaseService databaseService;

    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u5e93\u6570\u636e")
    @GetMapping(value={"/download"})
    @PreAuthorize(value="@el.check('database:list')")
    public void exportDatabase(HttpServletResponse response, DatabaseQueryCriteria criteria) throws IOException {
        this.databaseService.download(this.databaseService.queryAll(criteria), response);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5e93")
    @GetMapping
    @PreAuthorize(value="@el.check('database:list')")
    public ResponseEntity<Object> queryDatabase(DatabaseQueryCriteria criteria, Pageable pageable) {
        return new ResponseEntity(this.databaseService.queryAll(criteria, pageable), HttpStatus.OK);
    }

    @Log(value="\u65b0\u589e\u6570\u636e\u5e93")
    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5e93")
    @PostMapping
    @PreAuthorize(value="@el.check('database:add')")
    public ResponseEntity<Object> createDatabase(@Validated @RequestBody Database resources) {
        this.databaseService.create(resources);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Log(value="\u4fee\u6539\u6570\u636e\u5e93")
    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u5e93")
    @PutMapping
    @PreAuthorize(value="@el.check('database:edit')")
    public ResponseEntity<Object> updateDatabase(@Validated @RequestBody Database resources) {
        this.databaseService.update(resources);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Log(value="\u5220\u9664\u6570\u636e\u5e93")
    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5e93")
    @DeleteMapping
    @PreAuthorize(value="@el.check('database:del')")
    public ResponseEntity<Object> deleteDatabase(@RequestBody Set<String> ids) {
        this.databaseService.delete(ids);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Log(value="\u6d4b\u8bd5\u6570\u636e\u5e93\u94fe\u63a5")
    @ApiOperation(value="\u6d4b\u8bd5\u6570\u636e\u5e93\u94fe\u63a5")
    @PostMapping(value={"/testConnect"})
    @PreAuthorize(value="@el.check('database:testConnect')")
    public ResponseEntity<Object> testConnect(@Validated @RequestBody Database resources) {
        return new ResponseEntity((Object)this.databaseService.testConnection(resources), HttpStatus.CREATED);
    }

    @Log(value="\u6267\u884cSQL\u811a\u672c")
    @ApiOperation(value="\u6267\u884cSQL\u811a\u672c")
    @PostMapping(value={"/upload"})
    @PreAuthorize(value="@el.check('database:add')")
    public ResponseEntity<Object> uploadDatabase(@RequestBody MultipartFile file, HttpServletRequest request) throws Exception {
        String id = request.getParameter("id");
        DatabaseDto database = this.databaseService.findById(id);
        if (database != null) {
            String fileName = file.getOriginalFilename();
            File executeFile = new File(this.fileSavePath + fileName);
            FileUtil.del((File)executeFile);
            file.transferTo(executeFile);
            String result = SqlUtils.executeFile((String)database.getJdbcUrl(), (String)database.getUserName(), (String)database.getPwd(), (File)executeFile);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        throw new BadRequestException("Database not exist");
    }

    public DatabaseController(DatabaseService databaseService) {
        this.databaseService = databaseService;
    }
}

