/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.service.impl;

import cn.hutool.core.util.IdUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.modules.mnt.domain.DeployHistory;
import me.zhengjie.modules.mnt.repository.DeployHistoryRepository;
import me.zhengjie.modules.mnt.service.DeployHistoryService;
import me.zhengjie.modules.mnt.service.dto.DeployHistoryDto;
import me.zhengjie.modules.mnt.service.dto.DeployHistoryQueryCriteria;
import me.zhengjie.modules.mnt.service.mapstruct.DeployHistoryMapper;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.ValidationUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeployHistoryServiceImpl
implements DeployHistoryService {
    private final DeployHistoryRepository deployhistoryRepository;
    private final DeployHistoryMapper deployhistoryMapper;

    public Object queryAll(DeployHistoryQueryCriteria criteria, Pageable pageable) {
        Page page = this.deployhistoryRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), pageable);
        return PageUtil.toPage((Page)page.map(arg_0 -> ((DeployHistoryMapper)this.deployhistoryMapper).toDto(arg_0)));
    }

    public List<DeployHistoryDto> queryAll(DeployHistoryQueryCriteria criteria) {
        return this.deployhistoryMapper.toDto(this.deployhistoryRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder)));
    }

    public DeployHistoryDto findById(String id) {
        DeployHistory deployhistory = this.deployhistoryRepository.findById((Object)id).orElseGet(DeployHistory::new);
        ValidationUtil.isNull((Object)deployhistory.getId(), (String)"DeployHistory", (String)"id", (Object)id);
        return (DeployHistoryDto)this.deployhistoryMapper.toDto((Object)deployhistory);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(DeployHistory resources) {
        resources.setId(IdUtil.simpleUUID());
        this.deployhistoryRepository.save((Object)resources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<String> ids) {
        for (String id : ids) {
            this.deployhistoryRepository.deleteById((Object)id);
        }
    }

    public void download(List<DeployHistoryDto> queryAll, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (DeployHistoryDto deployHistoryDto : queryAll) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u90e8\u7f72\u7f16\u53f7", deployHistoryDto.getDeployId());
            map.put("\u5e94\u7528\u540d\u79f0", deployHistoryDto.getAppName());
            map.put("\u90e8\u7f72IP", deployHistoryDto.getIp());
            map.put("\u90e8\u7f72\u65f6\u95f4", deployHistoryDto.getDeployDate());
            map.put("\u90e8\u7f72\u4eba\u5458", deployHistoryDto.getDeployUser());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public DeployHistoryServiceImpl(DeployHistoryRepository deployhistoryRepository, DeployHistoryMapper deployhistoryMapper) {
        this.deployhistoryRepository = deployhistoryRepository;
        this.deployhistoryMapper = deployhistoryMapper;
    }
}

