/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.service.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.exception.EntityExistException;
import me.zhengjie.modules.system.domain.Job;
import me.zhengjie.modules.system.repository.JobRepository;
import me.zhengjie.modules.system.repository.UserRepository;
import me.zhengjie.modules.system.service.JobService;
import me.zhengjie.modules.system.service.dto.JobDto;
import me.zhengjie.modules.system.service.dto.JobQueryCriteria;
import me.zhengjie.modules.system.service.mapstruct.JobMapper;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.ValidationUtil;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@CacheConfig(cacheNames={"job"})
public class JobServiceImpl
implements JobService {
    private final JobRepository jobRepository;
    private final JobMapper jobMapper;
    private final RedisUtils redisUtils;
    private final UserRepository userRepository;

    public Map<String, Object> queryAll(JobQueryCriteria criteria, Pageable pageable) {
        Page page = this.jobRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), pageable);
        return PageUtil.toPage((Object)page.map(arg_0 -> ((JobMapper)this.jobMapper).toDto(arg_0)).getContent(), (Object)page.getTotalElements());
    }

    public List<JobDto> queryAll(JobQueryCriteria criteria) {
        List list = this.jobRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder));
        return this.jobMapper.toDto(list);
    }

    @Cacheable(key="'id:' + #p0")
    public JobDto findById(Long id) {
        Job job = this.jobRepository.findById((Object)id).orElseGet(Job::new);
        ValidationUtil.isNull((Object)job.getId(), (String)"Job", (String)"id", (Object)id);
        return (JobDto)this.jobMapper.toDto((Object)job);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(Job resources) {
        Job job = this.jobRepository.findByName(resources.getName());
        if (job != null) {
            throw new EntityExistException(Job.class, "name", resources.getName());
        }
        this.jobRepository.save((Object)resources);
    }

    @CacheEvict(key="'id:' + #p0.id")
    @Transactional(rollbackFor={Exception.class})
    public void update(Job resources) {
        Job job = this.jobRepository.findById((Object)resources.getId()).orElseGet(Job::new);
        Job old = this.jobRepository.findByName(resources.getName());
        if (old != null && !old.getId().equals(resources.getId())) {
            throw new EntityExistException(Job.class, "name", resources.getName());
        }
        ValidationUtil.isNull((Object)job.getId(), (String)"Job", (String)"id", (Object)resources.getId());
        resources.setId(job.getId());
        this.jobRepository.save((Object)resources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<Long> ids) {
        this.jobRepository.deleteAllByIdIn(ids);
        this.redisUtils.delByKeys("job::id:", ids);
    }

    public void download(List<JobDto> jobDtos, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (JobDto jobDTO : jobDtos) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u5c97\u4f4d\u540d\u79f0", jobDTO.getName());
            map.put("\u5c97\u4f4d\u72b6\u6001", jobDTO.getEnabled() != false ? "\u542f\u7528" : "\u505c\u7528");
            map.put("\u521b\u5efa\u65e5\u671f", jobDTO.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public void verification(Set<Long> ids) {
        if (this.userRepository.countByJobs(ids) > 0) {
            throw new BadRequestException("\u6240\u9009\u7684\u5c97\u4f4d\u4e2d\u5b58\u5728\u7528\u6237\u5173\u8054\uff0c\u8bf7\u89e3\u9664\u5173\u8054\u518d\u8bd5\uff01");
        }
    }

    public JobServiceImpl(JobRepository jobRepository, JobMapper jobMapper, RedisUtils redisUtils, UserRepository userRepository) {
        this.jobRepository = jobRepository;
        this.jobMapper = jobMapper;
        this.redisUtils = redisUtils;
        this.userRepository = userRepository;
    }
}

