/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.rest;

import cn.hutool.core.collection.CollectionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.annotation.Log;
import me.zhengjie.base.BaseEntity;
import me.zhengjie.config.RsaProperties;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.system.domain.User;
import me.zhengjie.modules.system.domain.vo.UserPassVo;
import me.zhengjie.modules.system.service.DataService;
import me.zhengjie.modules.system.service.DeptService;
import me.zhengjie.modules.system.service.RoleService;
import me.zhengjie.modules.system.service.UserService;
import me.zhengjie.modules.system.service.VerifyService;
import me.zhengjie.modules.system.service.dto.RoleSmallDto;
import me.zhengjie.modules.system.service.dto.UserDto;
import me.zhengjie.modules.system.service.dto.UserQueryCriteria;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.RsaUtils;
import me.zhengjie.utils.SecurityUtils;
import me.zhengjie.utils.enums.CodeEnum;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7cfb\u7edf\uff1a\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/users"})
public class UserController {
    private final PasswordEncoder passwordEncoder;
    private final UserService userService;
    private final DataService dataService;
    private final DeptService deptService;
    private final RoleService roleService;
    private final VerifyService verificationCodeService;

    @ApiOperation(value="\u5bfc\u51fa\u7528\u6237\u6570\u636e")
    @GetMapping(value={"/download"})
    @PreAuthorize(value="@el.check('user:list')")
    public void exportUser(HttpServletResponse response, UserQueryCriteria criteria) throws IOException {
        this.userService.download(this.userService.queryAll(criteria), response);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237")
    @GetMapping
    @PreAuthorize(value="@el.check('user:list')")
    public ResponseEntity<Object> queryUser(UserQueryCriteria criteria, Pageable pageable) {
        if (!ObjectUtils.isEmpty((Object)criteria.getDeptId())) {
            criteria.getDeptIds().add(criteria.getDeptId());
            List data = this.deptService.findByPid(criteria.getDeptId().longValue());
            criteria.getDeptIds().addAll(this.deptService.getDeptChildren(data));
        }
        List dataScopes = this.dataService.getDeptIds(this.userService.findByName(SecurityUtils.getCurrentUsername()));
        if (!CollectionUtils.isEmpty((Collection)criteria.getDeptIds()) && !CollectionUtils.isEmpty((Collection)dataScopes)) {
            criteria.getDeptIds().retainAll(dataScopes);
            if (!CollectionUtil.isEmpty((Collection)criteria.getDeptIds())) {
                return new ResponseEntity(this.userService.queryAll(criteria, pageable), HttpStatus.OK);
            }
        } else {
            criteria.getDeptIds().addAll(dataScopes);
            return new ResponseEntity(this.userService.queryAll(criteria, pageable), HttpStatus.OK);
        }
        return new ResponseEntity((Object)PageUtil.toPage(null, (Object)0), HttpStatus.OK);
    }

    @Log(value="\u65b0\u589e\u7528\u6237")
    @ApiOperation(value="\u65b0\u589e\u7528\u6237")
    @PostMapping
    @PreAuthorize(value="@el.check('user:add')")
    public ResponseEntity<Object> createUser(@Validated @RequestBody User resources) {
        this.checkLevel(resources);
        resources.setPassword(this.passwordEncoder.encode((CharSequence)"123456"));
        this.userService.create(resources);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Log(value="\u4fee\u6539\u7528\u6237")
    @ApiOperation(value="\u4fee\u6539\u7528\u6237")
    @PutMapping
    @PreAuthorize(value="@el.check('user:edit')")
    public ResponseEntity<Object> updateUser(@Validated(value={BaseEntity.Update.class}) @RequestBody User resources) throws Exception {
        this.checkLevel(resources);
        this.userService.update(resources);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Log(value="\u4fee\u6539\u7528\u6237\uff1a\u4e2a\u4eba\u4e2d\u5fc3")
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\uff1a\u4e2a\u4eba\u4e2d\u5fc3")
    @PutMapping(value={"center"})
    public ResponseEntity<Object> centerUser(@Validated(value={BaseEntity.Update.class}) @RequestBody User resources) {
        if (!resources.getId().equals(SecurityUtils.getCurrentUserId())) {
            throw new BadRequestException("\u4e0d\u80fd\u4fee\u6539\u4ed6\u4eba\u8d44\u6599");
        }
        this.userService.updateCenter(resources);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Log(value="\u5220\u9664\u7528\u6237")
    @ApiOperation(value="\u5220\u9664\u7528\u6237")
    @DeleteMapping
    @PreAuthorize(value="@el.check('user:del')")
    public ResponseEntity<Object> deleteUser(@RequestBody Set<Long> ids) {
        for (Long id : ids) {
            Integer currentLevel = (Integer)Collections.min(this.roleService.findByUsersId(SecurityUtils.getCurrentUserId()).stream().map(RoleSmallDto::getLevel).collect(Collectors.toList()));
            Integer optLevel = (Integer)Collections.min(this.roleService.findByUsersId(id).stream().map(RoleSmallDto::getLevel).collect(Collectors.toList()));
            if (currentLevel <= optLevel) continue;
            throw new BadRequestException("\u89d2\u8272\u6743\u9650\u4e0d\u8db3\uff0c\u4e0d\u80fd\u5220\u9664\uff1a" + this.userService.findById(id.longValue()).getUsername());
        }
        this.userService.delete(ids);
        return new ResponseEntity(HttpStatus.OK);
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @PostMapping(value={"/updatePass"})
    public ResponseEntity<Object> updateUserPass(@RequestBody UserPassVo passVo) throws Exception {
        String oldPass = RsaUtils.decryptByPrivateKey((String)RsaProperties.privateKey, (String)passVo.getOldPass());
        String newPass = RsaUtils.decryptByPrivateKey((String)RsaProperties.privateKey, (String)passVo.getNewPass());
        UserDto user = this.userService.findByName(SecurityUtils.getCurrentUsername());
        if (!this.passwordEncoder.matches((CharSequence)oldPass, user.getPassword())) {
            throw new BadRequestException("\u4fee\u6539\u5931\u8d25\uff0c\u65e7\u5bc6\u7801\u9519\u8bef");
        }
        if (this.passwordEncoder.matches((CharSequence)newPass, user.getPassword())) {
            throw new BadRequestException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c");
        }
        this.userService.updatePass(user.getUsername(), this.passwordEncoder.encode((CharSequence)newPass));
        return new ResponseEntity(HttpStatus.OK);
    }

    @ApiOperation(value="\u4fee\u6539\u5934\u50cf")
    @PostMapping(value={"/updateAvatar"})
    public ResponseEntity<Object> updateUserAvatar(@RequestParam MultipartFile avatar) {
        return new ResponseEntity((Object)this.userService.updateAvatar(avatar), HttpStatus.OK);
    }

    @Log(value="\u4fee\u6539\u90ae\u7bb1")
    @ApiOperation(value="\u4fee\u6539\u90ae\u7bb1")
    @PostMapping(value={"/updateEmail/{code}"})
    public ResponseEntity<Object> updateUserEmail(@PathVariable String code, @RequestBody User user) throws Exception {
        UserDto userDto;
        String password = RsaUtils.decryptByPrivateKey((String)RsaProperties.privateKey, (String)user.getPassword());
        if (!this.passwordEncoder.matches((CharSequence)password, (userDto = this.userService.findByName(SecurityUtils.getCurrentUsername())).getPassword())) {
            throw new BadRequestException("\u5bc6\u7801\u9519\u8bef");
        }
        this.verificationCodeService.validated(CodeEnum.EMAIL_RESET_EMAIL_CODE.getKey() + user.getEmail(), code);
        this.userService.updateEmail(userDto.getUsername(), user.getEmail());
        return new ResponseEntity(HttpStatus.OK);
    }

    private void checkLevel(User resources) {
        Integer currentLevel = (Integer)Collections.min(this.roleService.findByUsersId(SecurityUtils.getCurrentUserId()).stream().map(RoleSmallDto::getLevel).collect(Collectors.toList()));
        Integer optLevel = this.roleService.findByRoles(resources.getRoles());
        if (currentLevel > optLevel) {
            throw new BadRequestException("\u89d2\u8272\u6743\u9650\u4e0d\u8db3");
        }
    }

    public static void main(String[] args) {
        String encode = new BCryptPasswordEncoder().encode((CharSequence)"123456");
        System.out.println("encode = " + encode);
    }

    public UserController(PasswordEncoder passwordEncoder, UserService userService, DataService dataService, DeptService deptService, RoleService roleService, VerifyService verificationCodeService) {
        this.passwordEncoder = passwordEncoder;
        this.userService = userService;
        this.dataService = dataService;
        this.deptService = deptService;
        this.roleService = roleService;
        this.verificationCodeService = verificationCodeService;
    }
}

