/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.service.impl;

import cn.hutool.core.date.DateUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.mnt.domain.App;
import me.zhengjie.modules.mnt.domain.Deploy;
import me.zhengjie.modules.mnt.domain.DeployHistory;
import me.zhengjie.modules.mnt.domain.ServerDeploy;
import me.zhengjie.modules.mnt.repository.DeployRepository;
import me.zhengjie.modules.mnt.service.DeployHistoryService;
import me.zhengjie.modules.mnt.service.DeployService;
import me.zhengjie.modules.mnt.service.ServerDeployService;
import me.zhengjie.modules.mnt.service.dto.AppDto;
import me.zhengjie.modules.mnt.service.dto.DeployDto;
import me.zhengjie.modules.mnt.service.dto.DeployQueryCriteria;
import me.zhengjie.modules.mnt.service.dto.ServerDeployDto;
import me.zhengjie.modules.mnt.service.mapstruct.DeployMapper;
import me.zhengjie.modules.mnt.util.ExecuteShellUtil;
import me.zhengjie.modules.mnt.util.ScpClientUtil;
import me.zhengjie.modules.mnt.websocket.MsgType;
import me.zhengjie.modules.mnt.websocket.SocketMsg;
import me.zhengjie.modules.mnt.websocket.WebSocketServer;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.SecurityUtils;
import me.zhengjie.utils.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeployServiceImpl
implements DeployService {
    private static final Logger log = LoggerFactory.getLogger(DeployServiceImpl.class);
    private final String FILE_SEPARATOR = "/";
    private final DeployRepository deployRepository;
    private final DeployMapper deployMapper;
    private final ServerDeployService serverDeployService;
    private final DeployHistoryService deployHistoryService;
    private final Integer count = 30;

    public Object queryAll(DeployQueryCriteria criteria, Pageable pageable) {
        Page page = this.deployRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), pageable);
        return PageUtil.toPage((Page)page.map(arg_0 -> ((DeployMapper)this.deployMapper).toDto(arg_0)));
    }

    public List<DeployDto> queryAll(DeployQueryCriteria criteria) {
        return this.deployMapper.toDto(this.deployRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder)));
    }

    public DeployDto findById(Long id) {
        Deploy deploy = this.deployRepository.findById((Object)id).orElseGet(Deploy::new);
        ValidationUtil.isNull((Object)deploy.getId(), (String)"Deploy", (String)"id", (Object)id);
        return (DeployDto)this.deployMapper.toDto((Object)deploy);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(Deploy resources) {
        this.deployRepository.save((Object)resources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(Deploy resources) {
        Deploy deploy = this.deployRepository.findById((Object)resources.getId()).orElseGet(Deploy::new);
        ValidationUtil.isNull((Object)deploy.getId(), (String)"Deploy", (String)"id", (Object)resources.getId());
        deploy.copy(resources);
        this.deployRepository.save((Object)deploy);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<Long> ids) {
        for (Long id : ids) {
            this.deployRepository.deleteById((Object)id);
        }
    }

    public void deploy(String fileSavePath, Long id) {
        this.deployApp(fileSavePath, id);
    }

    private void deployApp(String fileSavePath, Long id) {
        DeployDto deploy = this.findById(id);
        if (deploy == null) {
            this.sendMsg("\u90e8\u7f72\u4fe1\u606f\u4e0d\u5b58\u5728", MsgType.ERROR);
            throw new BadRequestException("\u90e8\u7f72\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        AppDto app = deploy.getApp();
        if (app == null) {
            this.sendMsg("\u5305\u5bf9\u5e94\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728", MsgType.ERROR);
            throw new BadRequestException("\u5305\u5bf9\u5e94\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        int port = app.getPort();
        String uploadPath = app.getUploadPath();
        StringBuilder sb = new StringBuilder();
        Set deploys = deploy.getDeploys();
        for (ServerDeployDto deployDTO : deploys) {
            String ip = deployDTO.getIp();
            ExecuteShellUtil executeShellUtil = this.getExecuteShellUtil(ip);
            boolean flag = this.checkFile(executeShellUtil, app);
            executeShellUtil.execute("mkdir -p " + app.getUploadPath());
            executeShellUtil.execute("mkdir -p " + app.getBackupPath());
            executeShellUtil.execute("mkdir -p " + app.getDeployPath());
            String msg = String.format("\u767b\u9646\u5230\u670d\u52a1\u5668:%s", ip);
            ScpClientUtil scpClientUtil = this.getScpClientUtil(ip);
            log.info(msg);
            this.sendMsg(msg, MsgType.INFO);
            msg = String.format("\u4e0a\u4f20\u6587\u4ef6\u5230\u670d\u52a1\u5668:%s<br>\u76ee\u5f55:%s\u4e0b\uff0c\u8bf7\u7a0d\u7b49...", ip, uploadPath);
            this.sendMsg(msg, MsgType.INFO);
            scpClientUtil.putFile(fileSavePath, uploadPath);
            if (flag) {
                this.sendMsg("\u505c\u6b62\u539f\u6765\u5e94\u7528", MsgType.INFO);
                this.stopApp(port, executeShellUtil);
                this.sendMsg("\u5907\u4efd\u539f\u6765\u5e94\u7528", MsgType.INFO);
                this.backupApp(executeShellUtil, ip, app.getDeployPath() + "/", app.getName(), app.getBackupPath() + "/", id);
            }
            this.sendMsg("\u90e8\u7f72\u5e94\u7528", MsgType.INFO);
            String deployScript = app.getDeployScript();
            executeShellUtil.execute(deployScript);
            this.sleep(3);
            this.sendMsg("\u5e94\u7528\u90e8\u7f72\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u90e8\u7f72\u7ed3\u679c\uff0c\u6216\u8005\u7a0d\u540e\u624b\u52a8\u67e5\u770b\u90e8\u7f72\u72b6\u6001", MsgType.INFO);
            int i = 0;
            boolean result = false;
            while (i++ < this.count && !(result = this.checkIsRunningStatus(port, executeShellUtil))) {
                this.sleep(6);
            }
            sb.append("\u670d\u52a1\u5668:").append(deployDTO.getName()).append("<br>\u5e94\u7528:").append(app.getName());
            this.sendResultMsg(result, sb);
            executeShellUtil.close();
        }
    }

    private void sleep(int second) {
        try {
            Thread.sleep(second * 1000);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void backupApp(ExecuteShellUtil executeShellUtil, String ip, String fileSavePath, String appName, String backupPath, Long id) {
        String deployDate = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        StringBuilder sb = new StringBuilder();
        backupPath = backupPath + appName + "/" + deployDate + "\n";
        sb.append("mkdir -p ").append(backupPath);
        sb.append("mv -f ").append(fileSavePath);
        sb.append(appName).append(" ").append(backupPath);
        log.info("\u5907\u4efd\u5e94\u7528\u811a\u672c:" + sb.toString());
        executeShellUtil.execute(sb.toString());
        DeployHistory deployHistory = new DeployHistory();
        deployHistory.setAppName(appName);
        deployHistory.setDeployUser(SecurityUtils.getCurrentUsername());
        deployHistory.setIp(ip);
        deployHistory.setDeployId(id);
        this.deployHistoryService.create(deployHistory);
    }

    private void stopApp(int port, ExecuteShellUtil executeShellUtil) {
        executeShellUtil.execute(String.format("lsof -i :%d|grep -v \"PID\"|awk '{print \"kill -9\",$2}'|sh", port));
    }

    private boolean checkIsRunningStatus(int port, ExecuteShellUtil executeShellUtil) {
        String result = executeShellUtil.executeForResult(String.format("fuser -n tcp %d", port));
        return result.indexOf("/tcp:") > 0;
    }

    private void sendMsg(String msg, MsgType msgType) {
        try {
            WebSocketServer.sendInfo((SocketMsg)new SocketMsg(msg, msgType), (String)"deploy");
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String serverStatus(Deploy resources) {
        Set serverDeploys = resources.getDeploys();
        App app = resources.getApp();
        for (ServerDeploy serverDeploy : serverDeploys) {
            StringBuilder sb = new StringBuilder();
            ExecuteShellUtil executeShellUtil = this.getExecuteShellUtil(serverDeploy.getIp());
            sb.append("\u670d\u52a1\u5668:").append(serverDeploy.getName()).append("<br>\u5e94\u7528:").append(app.getName());
            boolean result = this.checkIsRunningStatus(app.getPort(), executeShellUtil);
            if (result) {
                sb.append("<br>\u6b63\u5728\u8fd0\u884c");
                this.sendMsg(sb.toString(), MsgType.INFO);
            } else {
                sb.append("<br>\u5df2\u505c\u6b62!");
                this.sendMsg(sb.toString(), MsgType.ERROR);
            }
            log.info(sb.toString());
            executeShellUtil.close();
        }
        return "\u6267\u884c\u5b8c\u6bd5";
    }

    private boolean checkFile(ExecuteShellUtil executeShellUtil, AppDto appDTO) {
        String result = executeShellUtil.executeForResult("find " + appDTO.getDeployPath() + " -name " + appDTO.getName());
        return result.indexOf(appDTO.getName()) > 0;
    }

    public String startServer(Deploy resources) {
        Set deploys = resources.getDeploys();
        App app = resources.getApp();
        for (ServerDeploy deploy : deploys) {
            StringBuilder sb = new StringBuilder();
            ExecuteShellUtil executeShellUtil = this.getExecuteShellUtil(deploy.getIp());
            this.stopApp(app.getPort(), executeShellUtil);
            sb.append("\u670d\u52a1\u5668:").append(deploy.getName()).append("<br>\u5e94\u7528:").append(app.getName());
            this.sendMsg("\u4e0b\u53d1\u542f\u52a8\u547d\u4ee4", MsgType.INFO);
            executeShellUtil.execute(app.getStartScript());
            this.sleep(3);
            this.sendMsg("\u5e94\u7528\u542f\u52a8\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u542f\u52a8\u7ed3\u679c\uff0c\u6216\u8005\u7a0d\u540e\u624b\u52a8\u67e5\u770b\u8fd0\u884c\u72b6\u6001", MsgType.INFO);
            int i = 0;
            boolean result = false;
            while (i++ < this.count && !(result = this.checkIsRunningStatus(app.getPort(), executeShellUtil))) {
                this.sleep(6);
            }
            this.sendResultMsg(result, sb);
            log.info(sb.toString());
            executeShellUtil.close();
        }
        return "\u6267\u884c\u5b8c\u6bd5";
    }

    public String stopServer(Deploy resources) {
        Set deploys = resources.getDeploys();
        App app = resources.getApp();
        for (ServerDeploy deploy : deploys) {
            StringBuilder sb = new StringBuilder();
            ExecuteShellUtil executeShellUtil = this.getExecuteShellUtil(deploy.getIp());
            sb.append("\u670d\u52a1\u5668:").append(deploy.getName()).append("<br>\u5e94\u7528:").append(app.getName());
            this.sendMsg("\u4e0b\u53d1\u505c\u6b62\u547d\u4ee4", MsgType.INFO);
            this.stopApp(app.getPort(), executeShellUtil);
            this.sleep(1);
            boolean result = this.checkIsRunningStatus(app.getPort(), executeShellUtil);
            if (result) {
                sb.append("<br>\u5173\u95ed\u5931\u8d25!");
                this.sendMsg(sb.toString(), MsgType.ERROR);
            } else {
                sb.append("<br>\u5173\u95ed\u6210\u529f!");
                this.sendMsg(sb.toString(), MsgType.INFO);
            }
            log.info(sb.toString());
            executeShellUtil.close();
        }
        return "\u6267\u884c\u5b8c\u6bd5";
    }

    public String serverReduction(DeployHistory resources) {
        Long deployId = resources.getDeployId();
        Deploy deployInfo = this.deployRepository.findById((Object)deployId).orElseGet(Deploy::new);
        String deployDate = DateUtil.format((Date)resources.getDeployDate(), (String)"yyyyMMddHHmmss");
        App app = deployInfo.getApp();
        if (app == null) {
            this.sendMsg("\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a" + resources.getAppName(), MsgType.ERROR);
            throw new BadRequestException("\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a" + resources.getAppName());
        }
        String backupPath = app.getBackupPath() + "/";
        backupPath = backupPath + resources.getAppName() + "/" + deployDate;
        String deployPath = app.getDeployPath();
        String ip = resources.getIp();
        ExecuteShellUtil executeShellUtil = this.getExecuteShellUtil(ip);
        String msg = String.format("\u767b\u9646\u5230\u670d\u52a1\u5668:%s", ip);
        log.info(msg);
        this.sendMsg(msg, MsgType.INFO);
        this.sendMsg("\u505c\u6b62\u539f\u6765\u5e94\u7528", MsgType.INFO);
        this.stopApp(app.getPort(), executeShellUtil);
        this.sendMsg("\u5220\u9664\u5e94\u7528", MsgType.INFO);
        executeShellUtil.execute("rm -rf " + deployPath + "/" + resources.getAppName());
        this.sendMsg("\u8fd8\u539f\u5e94\u7528", MsgType.INFO);
        executeShellUtil.execute("cp -r " + backupPath + "/. " + deployPath);
        this.sendMsg("\u542f\u52a8\u5e94\u7528", MsgType.INFO);
        executeShellUtil.execute(app.getStartScript());
        this.sendMsg("\u5e94\u7528\u542f\u52a8\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u542f\u52a8\u7ed3\u679c\uff0c\u6216\u8005\u7a0d\u540e\u624b\u52a8\u67e5\u770b\u542f\u52a8\u72b6\u6001", MsgType.INFO);
        int i = 0;
        boolean result = false;
        while (i++ < this.count && !(result = this.checkIsRunningStatus(app.getPort(), executeShellUtil))) {
            this.sleep(6);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u670d\u52a1\u5668:").append(ip).append("<br>\u5e94\u7528:").append(resources.getAppName());
        this.sendResultMsg(result, sb);
        executeShellUtil.close();
        return "";
    }

    private ExecuteShellUtil getExecuteShellUtil(String ip) {
        ServerDeployDto serverDeployDTO = this.serverDeployService.findByIp(ip);
        if (serverDeployDTO == null) {
            this.sendMsg("IP\u5bf9\u5e94\u670d\u52a1\u5668\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a" + ip, MsgType.ERROR);
            throw new BadRequestException("IP\u5bf9\u5e94\u670d\u52a1\u5668\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a" + ip);
        }
        return new ExecuteShellUtil(ip, serverDeployDTO.getAccount(), serverDeployDTO.getPassword(), serverDeployDTO.getPort().intValue());
    }

    private ScpClientUtil getScpClientUtil(String ip) {
        ServerDeployDto serverDeployDTO = this.serverDeployService.findByIp(ip);
        if (serverDeployDTO == null) {
            this.sendMsg("IP\u5bf9\u5e94\u670d\u52a1\u5668\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a" + ip, MsgType.ERROR);
            throw new BadRequestException("IP\u5bf9\u5e94\u670d\u52a1\u5668\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a" + ip);
        }
        return ScpClientUtil.getInstance((String)ip, (int)serverDeployDTO.getPort(), (String)serverDeployDTO.getAccount(), (String)serverDeployDTO.getPassword());
    }

    private void sendResultMsg(boolean result, StringBuilder sb) {
        if (result) {
            sb.append("<br>\u542f\u52a8\u6210\u529f!");
            this.sendMsg(sb.toString(), MsgType.INFO);
        } else {
            sb.append("<br>\u542f\u52a8\u5931\u8d25!");
            this.sendMsg(sb.toString(), MsgType.ERROR);
        }
    }

    public void download(List<DeployDto> queryAll, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (DeployDto deployDto : queryAll) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u5e94\u7528\u540d\u79f0", deployDto.getApp().getName());
            map.put("\u670d\u52a1\u5668", deployDto.getServers());
            map.put("\u90e8\u7f72\u65e5\u671f", deployDto.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public DeployServiceImpl(DeployRepository deployRepository, DeployMapper deployMapper, ServerDeployService serverDeployService, DeployHistoryService deployHistoryService) {
        this.deployRepository = deployRepository;
        this.deployMapper = deployMapper;
        this.serverDeployService = serverDeployService;
        this.deployHistoryService = deployHistoryService;
    }
}

