/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.service.impl;

import cn.hutool.core.util.IdUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.modules.mnt.domain.Database;
import me.zhengjie.modules.mnt.repository.DatabaseRepository;
import me.zhengjie.modules.mnt.service.DatabaseService;
import me.zhengjie.modules.mnt.service.dto.DatabaseDto;
import me.zhengjie.modules.mnt.service.dto.DatabaseQueryCriteria;
import me.zhengjie.modules.mnt.service.mapstruct.DatabaseMapper;
import me.zhengjie.modules.mnt.util.SqlUtils;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DatabaseServiceImpl
implements DatabaseService {
    private static final Logger log = LoggerFactory.getLogger(DatabaseServiceImpl.class);
    private final DatabaseRepository databaseRepository;
    private final DatabaseMapper databaseMapper;

    public Object queryAll(DatabaseQueryCriteria criteria, Pageable pageable) {
        Page page = this.databaseRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), pageable);
        return PageUtil.toPage((Page)page.map(arg_0 -> ((DatabaseMapper)this.databaseMapper).toDto(arg_0)));
    }

    public List<DatabaseDto> queryAll(DatabaseQueryCriteria criteria) {
        return this.databaseMapper.toDto(this.databaseRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder)));
    }

    public DatabaseDto findById(String id) {
        Database database = this.databaseRepository.findById((Object)id).orElseGet(Database::new);
        ValidationUtil.isNull((Object)database.getId(), (String)"Database", (String)"id", (Object)id);
        return (DatabaseDto)this.databaseMapper.toDto((Object)database);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(Database resources) {
        resources.setId(IdUtil.simpleUUID());
        this.databaseRepository.save((Object)resources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(Database resources) {
        Database database = this.databaseRepository.findById((Object)resources.getId()).orElseGet(Database::new);
        ValidationUtil.isNull((Object)database.getId(), (String)"Database", (String)"id", (Object)resources.getId());
        database.copy(resources);
        this.databaseRepository.save((Object)database);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<String> ids) {
        for (String id : ids) {
            this.databaseRepository.deleteById((Object)id);
        }
    }

    public boolean testConnection(Database resources) {
        try {
            return SqlUtils.testConnection((String)resources.getJdbcUrl(), (String)resources.getUserName(), (String)resources.getPwd());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public void download(List<DatabaseDto> queryAll, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (DatabaseDto databaseDto : queryAll) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u6570\u636e\u5e93\u540d\u79f0", databaseDto.getName());
            map.put("\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740", databaseDto.getJdbcUrl());
            map.put("\u7528\u6237\u540d", databaseDto.getUserName());
            map.put("\u521b\u5efa\u65e5\u671f", databaseDto.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public DatabaseServiceImpl(DatabaseRepository databaseRepository, DatabaseMapper databaseMapper) {
        this.databaseRepository = databaseRepository;
        this.databaseMapper = databaseMapper;
    }
}

