/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.zhengjie.modules.system.domain.Dept;
import me.zhengjie.modules.system.service.DataService;
import me.zhengjie.modules.system.service.DeptService;
import me.zhengjie.modules.system.service.RoleService;
import me.zhengjie.modules.system.service.dto.RoleSmallDto;
import me.zhengjie.modules.system.service.dto.UserDto;
import me.zhengjie.modules.system.service.impl.DataServiceImpl;
import me.zhengjie.utils.enums.DataScopeEnum;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"data"})
public class DataServiceImpl
implements DataService {
    private final RoleService roleService;
    private final DeptService deptService;

    @Cacheable(key="'user:' + #p0.id")
    public List<Long> getDeptIds(UserDto user) {
        HashSet<Long> deptIds = new HashSet<Long>();
        List roleSet = this.roleService.findByUsersId(user.getId());
        block4: for (RoleSmallDto role : roleSet) {
            DataScopeEnum dataScopeEnum = DataScopeEnum.find((String)role.getDataScope());
            switch (1.$SwitchMap$me$zhengjie$utils$enums$DataScopeEnum[Objects.requireNonNull(dataScopeEnum).ordinal()]) {
                case 1: {
                    deptIds.add(user.getDept().getId());
                    continue block4;
                }
                case 2: {
                    deptIds.addAll(this.getCustomize(deptIds, role));
                    continue block4;
                }
            }
            return new ArrayList<Long>(deptIds);
        }
        return new ArrayList<Long>(deptIds);
    }

    public Set<Long> getCustomize(Set<Long> deptIds, RoleSmallDto role) {
        Set depts = this.deptService.findByRoleId(role.getId());
        for (Dept dept : depts) {
            deptIds.add(dept.getId());
            List deptChildren = this.deptService.findByPid(dept.getId().longValue());
            if (deptChildren == null || deptChildren.size() == 0) continue;
            deptIds.addAll(this.deptService.getDeptChildren(deptChildren));
        }
        return deptIds;
    }

    public DataServiceImpl(RoleService roleService, DeptService deptService) {
        this.roleService = roleService;
        this.deptService = deptService;
    }
}

