/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.rest;

import cn.hutool.core.collection.CollectionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.annotation.Log;
import me.zhengjie.base.BaseEntity;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.system.domain.Menu;
import me.zhengjie.modules.system.service.MenuService;
import me.zhengjie.modules.system.service.dto.MenuDto;
import me.zhengjie.modules.system.service.dto.MenuQueryCriteria;
import me.zhengjie.modules.system.service.mapstruct.MenuMapper;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.SecurityUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7cfb\u7edf\uff1a\u83dc\u5355\u7ba1\u7406"})
@RequestMapping(value={"/api/menus"})
public class MenuController {
    private final MenuService menuService;
    private final MenuMapper menuMapper;
    private static final String ENTITY_NAME = "menu";

    @ApiOperation(value="\u5bfc\u51fa\u83dc\u5355\u6570\u636e")
    @GetMapping(value={"/download"})
    @PreAuthorize(value="@el.check('menu:list')")
    public void exportMenu(HttpServletResponse response, MenuQueryCriteria criteria) throws Exception {
        this.menuService.download(this.menuService.queryAll(criteria, Boolean.valueOf(false)), response);
    }

    @GetMapping(value={"/build"})
    @ApiOperation(value="\u83b7\u53d6\u524d\u7aef\u6240\u9700\u83dc\u5355")
    public ResponseEntity<Object> buildMenus() {
        List menuDtoList = this.menuService.findByUser(SecurityUtils.getCurrentUserId());
        List menuDtos = this.menuService.buildTree(menuDtoList);
        return new ResponseEntity(this.menuService.buildMenus(menuDtos), HttpStatus.OK);
    }

    @ApiOperation(value="\u8fd4\u56de\u5168\u90e8\u7684\u83dc\u5355")
    @GetMapping(value={"/lazy"})
    @PreAuthorize(value="@el.check('menu:list','roles:list')")
    public ResponseEntity<Object> queryAllMenu(@RequestParam Long pid) {
        return new ResponseEntity((Object)this.menuService.getMenus(pid), HttpStatus.OK);
    }

    @ApiOperation(value="\u6839\u636e\u83dc\u5355ID\u8fd4\u56de\u6240\u6709\u5b50\u8282\u70b9ID\uff0c\u5305\u542b\u81ea\u8eabID")
    @GetMapping(value={"/child"})
    @PreAuthorize(value="@el.check('menu:list','roles:list')")
    public ResponseEntity<Object> childMenu(@RequestParam Long id) {
        Set menuSet = new HashSet<Menu>();
        List menuList = this.menuService.getMenus(id);
        menuSet.add(this.menuService.findOne(id));
        menuSet = this.menuService.getChildMenus(this.menuMapper.toEntity(menuList), menuSet);
        Set ids = menuSet.stream().map(Menu::getId).collect(Collectors.toSet());
        return new ResponseEntity(ids, HttpStatus.OK);
    }

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u83dc\u5355")
    @PreAuthorize(value="@el.check('menu:list')")
    public ResponseEntity<Object> queryMenu(MenuQueryCriteria criteria) throws Exception {
        List menuDtoList = this.menuService.queryAll(criteria, Boolean.valueOf(true));
        return new ResponseEntity((Object)PageUtil.toPage((Object)menuDtoList, (Object)menuDtoList.size()), HttpStatus.OK);
    }

    @ApiOperation(value="\u67e5\u8be2\u83dc\u5355:\u6839\u636eID\u83b7\u53d6\u540c\u7ea7\u4e0e\u4e0a\u7ea7\u6570\u636e")
    @PostMapping(value={"/superior"})
    @PreAuthorize(value="@el.check('menu:list')")
    public ResponseEntity<Object> getMenuSuperior(@RequestBody List<Long> ids) {
        LinkedHashSet menuDtos = new LinkedHashSet();
        if (CollectionUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                MenuDto menuDto = this.menuService.findById(id.longValue());
                menuDtos.addAll(this.menuService.getSuperior(menuDto, new ArrayList()));
            }
            return new ResponseEntity((Object)this.menuService.buildTree(new ArrayList(menuDtos)), HttpStatus.OK);
        }
        return new ResponseEntity((Object)this.menuService.getMenus(null), HttpStatus.OK);
    }

    @Log(value="\u65b0\u589e\u83dc\u5355")
    @ApiOperation(value="\u65b0\u589e\u83dc\u5355")
    @PostMapping
    @PreAuthorize(value="@el.check('menu:add')")
    public ResponseEntity<Object> createMenu(@Validated @RequestBody Menu resources) {
        if (resources.getId() != null) {
            throw new BadRequestException("A new menu cannot already have an ID");
        }
        this.menuService.create(resources);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Log(value="\u4fee\u6539\u83dc\u5355")
    @ApiOperation(value="\u4fee\u6539\u83dc\u5355")
    @PutMapping
    @PreAuthorize(value="@el.check('menu:edit')")
    public ResponseEntity<Object> updateMenu(@Validated(value={BaseEntity.Update.class}) @RequestBody Menu resources) {
        this.menuService.update(resources);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Log(value="\u5220\u9664\u83dc\u5355")
    @ApiOperation(value="\u5220\u9664\u83dc\u5355")
    @DeleteMapping
    @PreAuthorize(value="@el.check('menu:del')")
    public ResponseEntity<Object> deleteMenu(@RequestBody Set<Long> ids) {
        Set<Object> menuSet = new HashSet<Menu>();
        for (Long id : ids) {
            List menuList = this.menuService.getMenus(id);
            menuSet.add(this.menuService.findOne(id));
            menuSet = this.menuService.getChildMenus(this.menuMapper.toEntity(menuList), menuSet);
        }
        this.menuService.delete(menuSet);
        return new ResponseEntity(HttpStatus.OK);
    }

    public MenuController(MenuService menuService, MenuMapper menuMapper) {
        this.menuService = menuService;
        this.menuMapper = menuMapper;
    }
}

