/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.websocket;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import me.zhengjie.modules.mnt.websocket.SocketMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/webSocket/{sid}")
@Component
public class WebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServer.class);
    private static CopyOnWriteArraySet<WebSocketServer> webSocketSet = new CopyOnWriteArraySet();
    private Session session;
    private String sid = "";

    @OnOpen
    public void onOpen(Session session, @PathParam(value="sid") String sid) {
        this.session = session;
        for (WebSocketServer webSocket : webSocketSet) {
            if (!webSocket.sid.equals(sid)) continue;
            webSocketSet.remove(webSocket);
        }
        webSocketSet.add(this);
        this.sid = sid;
    }

    @OnClose
    public void onClose() {
        webSocketSet.remove(this);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        log.info("\u6536\u5230\u6765" + this.sid + "\u7684\u4fe1\u606f:" + message);
        for (WebSocketServer item : webSocketSet) {
            try {
                item.sendMessage(message);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        log.error("\u53d1\u751f\u9519\u8bef");
        error.printStackTrace();
    }

    private void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }

    public static void sendInfo(SocketMsg socketMsg, @PathParam(value="sid") String sid) throws IOException {
        String message = JSONObject.toJSONString((Object)socketMsg);
        log.info("\u63a8\u9001\u6d88\u606f\u5230" + sid + "\uff0c\u63a8\u9001\u5185\u5bb9:" + message);
        for (WebSocketServer item : webSocketSet) {
            try {
                if (sid == null) {
                    item.sendMessage(message);
                    continue;
                }
                if (!item.sid.equals(sid)) continue;
                item.sendMessage(message);
            }
            catch (IOException iOException) {}
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketServer that = (WebSocketServer)o;
        return Objects.equals(this.session, that.session) && Objects.equals(this.sid, that.sid);
    }

    public int hashCode() {
        return Objects.hash(this.session, this.sid);
    }
}

