/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.util;

import cn.hutool.core.io.IoUtil;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteShellUtil {
    private static final Logger log = LoggerFactory.getLogger(ExecuteShellUtil.class);
    private Vector<String> stdout;
    Session session;

    public ExecuteShellUtil(String ipAddress, String username, String password, int port) {
        try {
            JSch jsch = new JSch();
            this.session = jsch.getSession(username, ipAddress, port);
            this.session.setPassword(password);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.connect(3000);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String command) {
        int returnCode = 0;
        ChannelShell channel = null;
        PrintWriter printWriter = null;
        BufferedReader input = null;
        this.stdout = new Vector();
        try {
            String line;
            channel = (ChannelShell)this.session.openChannel("shell");
            channel.connect();
            input = new BufferedReader(new InputStreamReader(channel.getInputStream()));
            printWriter = new PrintWriter(channel.getOutputStream());
            printWriter.println(command);
            printWriter.println("exit");
            printWriter.flush();
            log.info("The remote command is: ");
            while ((line = input.readLine()) != null) {
                this.stdout.add(line);
                System.out.println(line);
            }
            IoUtil.close((Closeable)printWriter);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            IoUtil.close(printWriter);
            IoUtil.close(input);
            if (channel != null) {
                channel.disconnect();
            }
        }
        IoUtil.close((Closeable)input);
        if (channel != null) {
            channel.disconnect();
        }
        return returnCode;
    }

    public void close() {
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public String executeForResult(String command) {
        this.execute(command);
        StringBuilder sb = new StringBuilder();
        for (String str : this.stdout) {
            sb.append(str);
        }
        return sb.toString();
    }
}

