/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.service.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.modules.mnt.domain.ServerDeploy;
import me.zhengjie.modules.mnt.repository.ServerDeployRepository;
import me.zhengjie.modules.mnt.service.ServerDeployService;
import me.zhengjie.modules.mnt.service.dto.ServerDeployDto;
import me.zhengjie.modules.mnt.service.dto.ServerDeployQueryCriteria;
import me.zhengjie.modules.mnt.service.mapstruct.ServerDeployMapper;
import me.zhengjie.modules.mnt.util.ExecuteShellUtil;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.ValidationUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServerDeployServiceImpl
implements ServerDeployService {
    private final ServerDeployRepository serverDeployRepository;
    private final ServerDeployMapper serverDeployMapper;

    public Object queryAll(ServerDeployQueryCriteria criteria, Pageable pageable) {
        Page page = this.serverDeployRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), pageable);
        return PageUtil.toPage((Page)page.map(arg_0 -> ((ServerDeployMapper)this.serverDeployMapper).toDto(arg_0)));
    }

    public List<ServerDeployDto> queryAll(ServerDeployQueryCriteria criteria) {
        return this.serverDeployMapper.toDto(this.serverDeployRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder)));
    }

    public ServerDeployDto findById(Long id) {
        ServerDeploy server = this.serverDeployRepository.findById((Object)id).orElseGet(ServerDeploy::new);
        ValidationUtil.isNull((Object)server.getId(), (String)"ServerDeploy", (String)"id", (Object)id);
        return (ServerDeployDto)this.serverDeployMapper.toDto((Object)server);
    }

    public ServerDeployDto findByIp(String ip) {
        ServerDeploy deploy = this.serverDeployRepository.findByIp(ip);
        return (ServerDeployDto)this.serverDeployMapper.toDto((Object)deploy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean testConnect(ServerDeploy resources) {
        try (ExecuteShellUtil executeShellUtil = null;){
            executeShellUtil = new ExecuteShellUtil(resources.getIp(), resources.getAccount(), resources.getPassword(), resources.getPort().intValue());
            Boolean bl = executeShellUtil.execute("ls") == 0;
            return bl;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(ServerDeploy resources) {
        this.serverDeployRepository.save((Object)resources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ServerDeploy resources) {
        ServerDeploy serverDeploy = this.serverDeployRepository.findById((Object)resources.getId()).orElseGet(ServerDeploy::new);
        ValidationUtil.isNull((Object)serverDeploy.getId(), (String)"ServerDeploy", (String)"id", (Object)resources.getId());
        serverDeploy.copy(resources);
        this.serverDeployRepository.save((Object)serverDeploy);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<Long> ids) {
        for (Long id : ids) {
            this.serverDeployRepository.deleteById((Object)id);
        }
    }

    public void download(List<ServerDeployDto> queryAll, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (ServerDeployDto deployDto : queryAll) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u670d\u52a1\u5668\u540d\u79f0", deployDto.getName());
            map.put("\u670d\u52a1\u5668IP", deployDto.getIp());
            map.put("\u7aef\u53e3", deployDto.getPort());
            map.put("\u8d26\u53f7", deployDto.getAccount());
            map.put("\u521b\u5efa\u65e5\u671f", deployDto.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public ServerDeployServiceImpl(ServerDeployRepository serverDeployRepository, ServerDeployMapper serverDeployMapper) {
        this.serverDeployRepository = serverDeployRepository;
        this.serverDeployMapper = serverDeployMapper;
    }
}

