/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.security.service;

import cn.hutool.core.util.RandomUtil;
import javax.annotation.Resource;
import me.zhengjie.modules.security.service.dto.JwtUserDto;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class UserCacheManager {
    @Resource
    private RedisUtils redisUtils;
    @Value(value="${login.user-cache.idle-time}")
    private long idleTime;

    public JwtUserDto getUserCache(String userName) {
        Object obj;
        if (StringUtils.isNotEmpty((CharSequence)userName) && (obj = this.redisUtils.hget("USER-LOGIN-DATA", userName)) != null) {
            return (JwtUserDto)obj;
        }
        return null;
    }

    @Async
    public void addUserCache(String userName, JwtUserDto user) {
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            long time = this.idleTime + (long)RandomUtil.randomInt((int)900, (int)1800);
            this.redisUtils.hset("USER-LOGIN-DATA", userName, (Object)user, time);
        }
    }

    @Async
    public void cleanUserCache(String userName) {
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            this.redisUtils.hdel("USER-LOGIN-DATA", new Object[]{userName});
        }
    }
}

