/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.config.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import me.zhengjie.utils.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TheadFactoryName
implements ThreadFactory {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private static final String DEF_NAME = "el-pool-";

    public TheadFactoryName() {
        this(DEF_NAME);
    }

    public TheadFactoryName(String name) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = (StringUtils.isNotBlank((CharSequence)name) ? name : DEF_NAME) + "-" + POOL_NUMBER.getAndIncrement();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + "-exec-" + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

