/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.quartz.utils;

import java.util.Date;
import javax.annotation.Resource;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.quartz.domain.QuartzJob;
import me.zhengjie.modules.quartz.utils.ExecutionJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QuartzManage {
    private static final Logger log = LoggerFactory.getLogger(QuartzManage.class);
    private static final String JOB_NAME = "TASK_";
    @Resource
    private Scheduler scheduler;

    public void addJob(QuartzJob quartzJob) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(ExecutionJob.class).withIdentity(JOB_NAME + quartzJob.getId()).build();
            Trigger cronTrigger = TriggerBuilder.newTrigger().withIdentity(JOB_NAME + quartzJob.getId()).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)quartzJob.getCronExpression())).build();
            cronTrigger.getJobDataMap().put("JOB_KEY", (Object)quartzJob);
            ((CronTriggerImpl)cronTrigger).setStartTime(new Date());
            this.scheduler.scheduleJob(jobDetail, cronTrigger);
            if (quartzJob.getIsPause().booleanValue()) {
                this.pauseJob(quartzJob);
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new BadRequestException("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void updateJobCron(QuartzJob quartzJob) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)(JOB_NAME + quartzJob.getId()));
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                this.addJob(quartzJob);
                trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            }
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)quartzJob.getCronExpression());
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            ((CronTriggerImpl)trigger).setStartTime(new Date());
            trigger.getJobDataMap().put("JOB_KEY", (Object)quartzJob);
            this.scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            if (quartzJob.getIsPause().booleanValue()) {
                this.pauseJob(quartzJob);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new BadRequestException("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void deleteJob(QuartzJob quartzJob) {
        try {
            JobKey jobKey = JobKey.jobKey((String)(JOB_NAME + quartzJob.getId()));
            this.scheduler.pauseJob(jobKey);
            this.scheduler.deleteJob(jobKey);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new BadRequestException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void resumeJob(QuartzJob quartzJob) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)(JOB_NAME + quartzJob.getId()));
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                this.addJob(quartzJob);
            }
            JobKey jobKey = JobKey.jobKey((String)(JOB_NAME + quartzJob.getId()));
            this.scheduler.resumeJob(jobKey);
        }
        catch (Exception e) {
            log.error("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new BadRequestException("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void runJobNow(QuartzJob quartzJob) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)(JOB_NAME + quartzJob.getId()));
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                this.addJob(quartzJob);
            }
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("JOB_KEY", (Object)quartzJob);
            JobKey jobKey = JobKey.jobKey((String)(JOB_NAME + quartzJob.getId()));
            this.scheduler.triggerJob(jobKey, dataMap);
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
            throw new BadRequestException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25");
        }
    }

    public void pauseJob(QuartzJob quartzJob) {
        try {
            JobKey jobKey = JobKey.jobKey((String)(JOB_NAME + quartzJob.getId()));
            this.scheduler.pauseJob(jobKey);
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u6682\u505c\u5931\u8d25", (Throwable)e);
            throw new BadRequestException("\u5b9a\u65f6\u4efb\u52a1\u6682\u505c\u5931\u8d25");
        }
    }
}

