/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.annotation.Log;
import me.zhengjie.modules.mnt.domain.ServerDeploy;
import me.zhengjie.modules.mnt.service.ServerDeployService;
import me.zhengjie.modules.mnt.service.dto.ServerDeployQueryCriteria;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fd0\u7ef4\uff1a\u670d\u52a1\u5668\u7ba1\u7406"})
@RequestMapping(value={"/api/serverDeploy"})
public class ServerDeployController {
    private final ServerDeployService serverDeployService;

    @ApiOperation(value="\u5bfc\u51fa\u670d\u52a1\u5668\u6570\u636e")
    @GetMapping(value={"/download"})
    @PreAuthorize(value="@el.check('serverDeploy:list')")
    public void exportServerDeploy(HttpServletResponse response, ServerDeployQueryCriteria criteria) throws IOException {
        this.serverDeployService.download(this.serverDeployService.queryAll(criteria), response);
    }

    @ApiOperation(value="\u67e5\u8be2\u670d\u52a1\u5668")
    @GetMapping
    @PreAuthorize(value="@el.check('serverDeploy:list')")
    public ResponseEntity<Object> queryServerDeploy(ServerDeployQueryCriteria criteria, Pageable pageable) {
        return new ResponseEntity(this.serverDeployService.queryAll(criteria, pageable), HttpStatus.OK);
    }

    @Log(value="\u65b0\u589e\u670d\u52a1\u5668")
    @ApiOperation(value="\u65b0\u589e\u670d\u52a1\u5668")
    @PostMapping
    @PreAuthorize(value="@el.check('serverDeploy:add')")
    public ResponseEntity<Object> createServerDeploy(@Validated @RequestBody ServerDeploy resources) {
        this.serverDeployService.create(resources);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Log(value="\u4fee\u6539\u670d\u52a1\u5668")
    @ApiOperation(value="\u4fee\u6539\u670d\u52a1\u5668")
    @PutMapping
    @PreAuthorize(value="@el.check('serverDeploy:edit')")
    public ResponseEntity<Object> updateServerDeploy(@Validated @RequestBody ServerDeploy resources) {
        this.serverDeployService.update(resources);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Log(value="\u5220\u9664\u670d\u52a1\u5668")
    @ApiOperation(value="\u5220\u9664Server")
    @DeleteMapping
    @PreAuthorize(value="@el.check('serverDeploy:del')")
    public ResponseEntity<Object> deleteServerDeploy(@RequestBody Set<Long> ids) {
        this.serverDeployService.delete(ids);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Log(value="\u6d4b\u8bd5\u8fde\u63a5\u670d\u52a1\u5668")
    @ApiOperation(value="\u6d4b\u8bd5\u8fde\u63a5\u670d\u52a1\u5668")
    @PostMapping(value={"/testConnect"})
    @PreAuthorize(value="@el.check('serverDeploy:add')")
    public ResponseEntity<Object> testConnectServerDeploy(@Validated @RequestBody ServerDeploy resources) {
        return new ResponseEntity((Object)this.serverDeployService.testConnect(resources), HttpStatus.CREATED);
    }

    public ServerDeployController(ServerDeployService serverDeployService) {
        this.serverDeployService = serverDeployService;
    }
}

