/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.quartz.utils;

import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import me.zhengjie.config.thread.ThreadPoolExecutorUtil;
import me.zhengjie.domain.vo.EmailVo;
import me.zhengjie.modules.quartz.domain.QuartzJob;
import me.zhengjie.modules.quartz.domain.QuartzLog;
import me.zhengjie.modules.quartz.repository.QuartzLogRepository;
import me.zhengjie.modules.quartz.service.QuartzJobService;
import me.zhengjie.modules.quartz.utils.QuartzRunnable;
import me.zhengjie.service.EmailService;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.SpringContextHolder;
import me.zhengjie.utils.StringUtils;
import me.zhengjie.utils.ThrowableUtil;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ExecutionJob
extends QuartzJobBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ExecutorService executor = ThreadPoolExecutorUtil.getPoll((String)"el-quartz-job");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInternal(JobExecutionContext context) {
        QuartzJob quartzJob = (QuartzJob)context.getMergedJobDataMap().get((Object)"JOB_KEY");
        QuartzLogRepository quartzLogRepository = (QuartzLogRepository)SpringContextHolder.getBean(QuartzLogRepository.class);
        QuartzJobService quartzJobService = (QuartzJobService)SpringContextHolder.getBean(QuartzJobService.class);
        RedisUtils redisUtils = (RedisUtils)SpringContextHolder.getBean(RedisUtils.class);
        String uuid = quartzJob.getUuid();
        QuartzLog log = new QuartzLog();
        log.setJobName(quartzJob.getJobName());
        log.setBeanName(quartzJob.getBeanName());
        log.setMethodName(quartzJob.getMethodName());
        log.setParams(quartzJob.getParams());
        long startTime = System.currentTimeMillis();
        log.setCronExpression(quartzJob.getCronExpression());
        try {
            QuartzRunnable task = new QuartzRunnable(quartzJob.getBeanName(), quartzJob.getMethodName(), quartzJob.getParams());
            Future future = executor.submit(task);
            future.get();
            long times = System.currentTimeMillis() - startTime;
            log.setTime(Long.valueOf(times));
            if (StringUtils.isNotBlank((CharSequence)uuid)) {
                redisUtils.set(uuid, (Object)true);
            }
            log.setIsSuccess(Boolean.valueOf(true));
            this.logger.info("\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u4efb\u52a1\u540d\u79f0\uff1a" + quartzJob.getJobName() + ", \u6267\u884c\u65f6\u95f4\uff1a" + times + "\u6beb\u79d2");
            if (StringUtils.isNotBlank((CharSequence)quartzJob.getSubTask())) {
                String[] tasks = quartzJob.getSubTask().split("[,\uff0c]");
                quartzJobService.executionSubJob(tasks);
            }
        }
        catch (Exception e) {
            if (StringUtils.isNotBlank((CharSequence)uuid)) {
                redisUtils.set(uuid, (Object)false);
            }
            this.logger.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1\u540d\u79f0\uff1a" + quartzJob.getJobName());
            long times = System.currentTimeMillis() - startTime;
            log.setTime(Long.valueOf(times));
            log.setIsSuccess(Boolean.valueOf(false));
            log.setExceptionDetail(ThrowableUtil.getStackTrace((Throwable)e));
            if (quartzJob.getPauseAfterFailure() != null && quartzJob.getPauseAfterFailure().booleanValue()) {
                quartzJob.setIsPause(Boolean.valueOf(false));
                quartzJobService.updateIsPause(quartzJob);
            }
            if (quartzJob.getEmail() != null) {
                EmailService emailService = (EmailService)SpringContextHolder.getBean(EmailService.class);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{quartzJob.getEmail()})) {
                    EmailVo emailVo = this.taskAlarm(quartzJob, ThrowableUtil.getStackTrace((Throwable)e));
                    emailService.send(emailVo, emailService.find());
                }
            }
        }
        finally {
            quartzLogRepository.save((Object)log);
        }
    }

    private EmailVo taskAlarm(QuartzJob quartzJob, String msg) {
        EmailVo emailVo = new EmailVo();
        emailVo.setSubject("\u5b9a\u65f6\u4efb\u52a1\u3010" + quartzJob.getJobName() + "\u3011\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("task", quartzJob);
        data.put("msg", msg);
        TemplateEngine engine = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig("template", TemplateConfig.ResourceMode.CLASSPATH));
        Template template = engine.getTemplate("email/taskAlarm.ftl");
        emailVo.setContent(template.render(data));
        List<String> emails = Arrays.asList(quartzJob.getEmail().split("[,\uff0c]"));
        emailVo.setTos(emails);
        return emailVo;
    }
}

