/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.service.impl;

import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateUtil;
import java.util.Collections;
import java.util.Map;
import me.zhengjie.domain.vo.EmailVo;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.system.service.VerifyService;
import me.zhengjie.utils.RedisUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VerifyServiceImpl
implements VerifyService {
    @Value(value="${code.expiration}")
    private Long expiration;
    private final RedisUtils redisUtils;

    @Transactional(rollbackFor={Exception.class})
    public EmailVo sendEmail(String email, String key) {
        EmailVo emailVo;
        String redisKey = key + email;
        TemplateEngine engine = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig("template", TemplateConfig.ResourceMode.CLASSPATH));
        Template template = engine.getTemplate("email/email.ftl");
        Object oldCode = this.redisUtils.get(redisKey);
        if (oldCode == null) {
            String code = RandomUtil.randomNumbers((int)6);
            if (!this.redisUtils.set(redisKey, (Object)code, this.expiration.longValue())) {
                throw new BadRequestException("\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7f51\u7ad9\u8d1f\u8d23\u4eba");
            }
            String content = template.render((Map)Dict.create().set("code", (Object)code));
            emailVo = new EmailVo(Collections.singletonList(email), "EL-ADMIN\u540e\u53f0\u7ba1\u7406\u7cfb\u7edf", content);
        } else {
            String content = template.render((Map)Dict.create().set("code", oldCode));
            emailVo = new EmailVo(Collections.singletonList(email), "EL-ADMIN\u540e\u53f0\u7ba1\u7406\u7cfb\u7edf", content);
        }
        return emailVo;
    }

    public void validated(String key, String code) {
        Object value = this.redisUtils.get(key);
        if (value == null || !value.toString().equals(code)) {
            throw new BadRequestException("\u65e0\u6548\u9a8c\u8bc1\u7801");
        }
        this.redisUtils.del(new String[]{key});
    }

    public VerifyServiceImpl(RedisUtils redisUtils) {
        this.redisUtils = redisUtils;
    }
}

