/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.service.impl;

import cn.hutool.core.date.BetweenFormatter;
import cn.hutool.core.date.DateUtil;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.zhengjie.modules.system.service.MonitorService;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.StringUtils;
import org.springframework.stereotype.Service;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.VirtualMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;
import oshi.util.Util;

@Service
public class MonitorServiceImpl
implements MonitorService {
    private final DecimalFormat df = new DecimalFormat("0.00");

    public Map<String, Object> getServers() {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(8);
        try {
            SystemInfo si = new SystemInfo();
            OperatingSystem os = si.getOperatingSystem();
            HardwareAbstractionLayer hal = si.getHardware();
            resultMap.put("sys", this.getSystemInfo(os));
            resultMap.put("cpu", this.getCpuInfo(hal.getProcessor()));
            resultMap.put("memory", this.getMemoryInfo(hal.getMemory()));
            resultMap.put("swap", this.getSwapInfo(hal.getMemory()));
            resultMap.put("disk", this.getDiskInfo(os));
            resultMap.put("time", DateUtil.format((Date)new Date(), (String)"HH:mm:ss"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    private Map<String, Object> getDiskInfo(OperatingSystem os) {
        LinkedHashMap<String, Object> diskInfo = new LinkedHashMap<String, Object>();
        FileSystem fileSystem = os.getFileSystem();
        List fsArray = fileSystem.getFileStores();
        String osName = System.getProperty("os.name");
        long available = 0L;
        long total = 0L;
        for (OSFileStore fs : fsArray) {
            if (osName.toLowerCase().startsWith("win")) {
                available += fs.getUsableSpace();
                total += fs.getTotalSpace();
                continue;
            }
            available = fs.getUsableSpace();
            total = fs.getTotalSpace();
            break;
        }
        long used = total - available;
        diskInfo.put("total", total > 0L ? FileUtil.getSize((long)total) : "?");
        diskInfo.put("available", FileUtil.getSize((long)available));
        diskInfo.put("used", FileUtil.getSize((long)used));
        if (total != 0L) {
            diskInfo.put("usageRate", this.df.format((double)used / (double)total * 100.0));
        } else {
            diskInfo.put("usageRate", 0);
        }
        return diskInfo;
    }

    private Map<String, Object> getSwapInfo(GlobalMemory memory) {
        LinkedHashMap<String, Object> swapInfo = new LinkedHashMap<String, Object>();
        VirtualMemory virtualMemory = memory.getVirtualMemory();
        long total = virtualMemory.getSwapTotal();
        long used = virtualMemory.getSwapUsed();
        swapInfo.put("total", FormatUtil.formatBytes((long)total));
        swapInfo.put("used", FormatUtil.formatBytes((long)used));
        swapInfo.put("available", FormatUtil.formatBytes((long)(total - used)));
        if (used == 0L) {
            swapInfo.put("usageRate", 0);
        } else {
            swapInfo.put("usageRate", this.df.format((double)used / (double)total * 100.0));
        }
        return swapInfo;
    }

    private Map<String, Object> getMemoryInfo(GlobalMemory memory) {
        LinkedHashMap<String, Object> memoryInfo = new LinkedHashMap<String, Object>();
        memoryInfo.put("total", FormatUtil.formatBytes((long)memory.getTotal()));
        memoryInfo.put("available", FormatUtil.formatBytes((long)memory.getAvailable()));
        memoryInfo.put("used", FormatUtil.formatBytes((long)(memory.getTotal() - memory.getAvailable())));
        memoryInfo.put("usageRate", this.df.format((double)(memory.getTotal() - memory.getAvailable()) / (double)memory.getTotal() * 100.0));
        return memoryInfo;
    }

    private Map<String, Object> getCpuInfo(CentralProcessor processor) {
        long time;
        LinkedHashMap<String, Object> cpuInfo = new LinkedHashMap<String, Object>();
        cpuInfo.put("name", processor.getProcessorIdentifier().getName());
        cpuInfo.put("package", processor.getPhysicalPackageCount() + "\u4e2a\u7269\u7406CPU");
        cpuInfo.put("core", processor.getPhysicalProcessorCount() + "\u4e2a\u7269\u7406\u6838\u5fc3");
        cpuInfo.put("coreNumber", processor.getPhysicalProcessorCount());
        cpuInfo.put("logic", processor.getLogicalProcessorCount() + "\u4e2a\u903b\u8f91CPU");
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Util.sleep((long)time);
        long[] ticks = processor.getSystemCpuLoadTicks();
        for (time = 300L; Arrays.toString(prevTicks).equals(Arrays.toString(ticks)) && time < 1000L; time += 25L) {
            Util.sleep((long)25L);
            ticks = processor.getSystemCpuLoadTicks();
        }
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
        cpuInfo.put("used", this.df.format(100.0 * (double)user / (double)totalCpu + 100.0 * (double)sys / (double)totalCpu));
        cpuInfo.put("idle", this.df.format(100.0 * (double)idle / (double)totalCpu));
        return cpuInfo;
    }

    private Map<String, Object> getSystemInfo(OperatingSystem os) {
        LinkedHashMap<String, Object> systemInfo = new LinkedHashMap<String, Object>();
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        Date date = new Date(time);
        String formatBetween = DateUtil.formatBetween((Date)date, (Date)new Date(), (BetweenFormatter.Level)BetweenFormatter.Level.HOUR);
        systemInfo.put("os", os.toString());
        systemInfo.put("day", formatBetween);
        systemInfo.put("ip", StringUtils.getLocalIp());
        return systemInfo;
    }
}

