/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.security.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.modules.security.service.OnlineUserService;
import me.zhengjie.utils.EncryptUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth/online"})
@Api(tags={"\u7cfb\u7edf\uff1a\u5728\u7ebf\u7528\u6237\u7ba1\u7406"})
public class OnlineController {
    private final OnlineUserService onlineUserService;

    @ApiOperation(value="\u67e5\u8be2\u5728\u7ebf\u7528\u6237")
    @GetMapping
    @PreAuthorize(value="@el.check()")
    public ResponseEntity<Object> queryOnlineUser(String filter, Pageable pageable) {
        return new ResponseEntity((Object)this.onlineUserService.getAll(filter, pageable), HttpStatus.OK);
    }

    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e")
    @GetMapping(value={"/download"})
    @PreAuthorize(value="@el.check()")
    public void exportOnlineUser(HttpServletResponse response, String filter) throws IOException {
        this.onlineUserService.download(this.onlineUserService.getAll(filter), response);
    }

    @ApiOperation(value="\u8e22\u51fa\u7528\u6237")
    @DeleteMapping
    @PreAuthorize(value="@el.check()")
    public ResponseEntity<Object> deleteOnlineUser(@RequestBody Set<String> keys) throws Exception {
        for (String key : keys) {
            key = EncryptUtils.desDecrypt((String)key);
            this.onlineUserService.kickOut(key);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    public OnlineController(OnlineUserService onlineUserService) {
        this.onlineUserService = onlineUserService;
    }
}

