/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.mnt.service.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.mnt.domain.App;
import me.zhengjie.modules.mnt.repository.AppRepository;
import me.zhengjie.modules.mnt.service.AppService;
import me.zhengjie.modules.mnt.service.dto.AppDto;
import me.zhengjie.modules.mnt.service.dto.AppQueryCriteria;
import me.zhengjie.modules.mnt.service.mapstruct.AppMapper;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.ValidationUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppServiceImpl
implements AppService {
    private final AppRepository appRepository;
    private final AppMapper appMapper;

    public Object queryAll(AppQueryCriteria criteria, Pageable pageable) {
        Page page = this.appRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), pageable);
        return PageUtil.toPage((Page)page.map(arg_0 -> ((AppMapper)this.appMapper).toDto(arg_0)));
    }

    public List<AppDto> queryAll(AppQueryCriteria criteria) {
        return this.appMapper.toDto(this.appRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder)));
    }

    public AppDto findById(Long id) {
        App app = this.appRepository.findById((Object)id).orElseGet(App::new);
        ValidationUtil.isNull((Object)app.getId(), (String)"App", (String)"id", (Object)id);
        return (AppDto)this.appMapper.toDto((Object)app);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(App resources) {
        this.verification(resources);
        this.appRepository.save((Object)resources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(App resources) {
        this.verification(resources);
        App app = this.appRepository.findById((Object)resources.getId()).orElseGet(App::new);
        ValidationUtil.isNull((Object)app.getId(), (String)"App", (String)"id", (Object)resources.getId());
        app.copy(resources);
        this.appRepository.save((Object)app);
    }

    private void verification(App resources) {
        String opt = "/opt";
        String home = "/home";
        if (!resources.getUploadPath().startsWith(opt) && !resources.getUploadPath().startsWith(home)) {
            throw new BadRequestException("\u6587\u4ef6\u53ea\u80fd\u4e0a\u4f20\u5728opt\u76ee\u5f55\u6216\u8005home\u76ee\u5f55 ");
        }
        if (!resources.getDeployPath().startsWith(opt) && !resources.getDeployPath().startsWith(home)) {
            throw new BadRequestException("\u6587\u4ef6\u53ea\u80fd\u90e8\u7f72\u5728opt\u76ee\u5f55\u6216\u8005home\u76ee\u5f55 ");
        }
        if (!resources.getBackupPath().startsWith(opt) && !resources.getBackupPath().startsWith(home)) {
            throw new BadRequestException("\u6587\u4ef6\u53ea\u80fd\u5907\u4efd\u5728opt\u76ee\u5f55\u6216\u8005home\u76ee\u5f55 ");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<Long> ids) {
        for (Long id : ids) {
            this.appRepository.deleteById((Object)id);
        }
    }

    public void download(List<AppDto> queryAll, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (AppDto appDto : queryAll) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u5e94\u7528\u540d\u79f0", appDto.getName());
            map.put("\u7aef\u53e3", appDto.getPort());
            map.put("\u4e0a\u4f20\u76ee\u5f55", appDto.getUploadPath());
            map.put("\u90e8\u7f72\u76ee\u5f55", appDto.getDeployPath());
            map.put("\u5907\u4efd\u76ee\u5f55", appDto.getBackupPath());
            map.put("\u542f\u52a8\u811a\u672c", appDto.getStartScript());
            map.put("\u90e8\u7f72\u811a\u672c", appDto.getDeployScript());
            map.put("\u521b\u5efa\u65e5\u671f", appDto.getCreateTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public AppServiceImpl(AppRepository appRepository, AppMapper appMapper) {
        this.appRepository = appRepository;
        this.appMapper = appMapper;
    }
}

