/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import me.zhengjie.modules.system.domain.Dict;
import me.zhengjie.modules.system.domain.DictDetail;
import me.zhengjie.modules.system.repository.DictDetailRepository;
import me.zhengjie.modules.system.repository.DictRepository;
import me.zhengjie.modules.system.service.DictDetailService;
import me.zhengjie.modules.system.service.dto.DictDetailDto;
import me.zhengjie.modules.system.service.dto.DictDetailQueryCriteria;
import me.zhengjie.modules.system.service.mapstruct.DictDetailMapper;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.ValidationUtil;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@CacheConfig(cacheNames={"dict"})
public class DictDetailServiceImpl
implements DictDetailService {
    private final DictRepository dictRepository;
    private final DictDetailRepository dictDetailRepository;
    private final DictDetailMapper dictDetailMapper;
    private final RedisUtils redisUtils;

    public Map<String, Object> queryAll(DictDetailQueryCriteria criteria, Pageable pageable) {
        Page page = this.dictDetailRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)criteria, (CriteriaBuilder)criteriaBuilder), pageable);
        return PageUtil.toPage((Page)page.map(arg_0 -> ((DictDetailMapper)this.dictDetailMapper).toDto(arg_0)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(DictDetail resources) {
        this.dictDetailRepository.save((Object)resources);
        this.delCaches(resources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(DictDetail resources) {
        DictDetail dictDetail = this.dictDetailRepository.findById((Object)resources.getId()).orElseGet(DictDetail::new);
        ValidationUtil.isNull((Object)dictDetail.getId(), (String)"DictDetail", (String)"id", (Object)resources.getId());
        resources.setId(dictDetail.getId());
        this.dictDetailRepository.save((Object)resources);
        this.delCaches(resources);
    }

    @Cacheable(key="'name:' + #p0")
    public List<DictDetailDto> getDictByName(String name) {
        return this.dictDetailMapper.toDto(this.dictDetailRepository.findByDictName(name));
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Long id) {
        DictDetail dictDetail = this.dictDetailRepository.findById((Object)id).orElseGet(DictDetail::new);
        this.delCaches(dictDetail);
        this.dictDetailRepository.deleteById((Object)id);
    }

    public void delCaches(DictDetail dictDetail) {
        Dict dict = this.dictRepository.findById((Object)dictDetail.getDict().getId()).orElseGet(Dict::new);
        this.redisUtils.del(new String[]{"dict::name:" + dict.getName()});
    }

    public DictDetailServiceImpl(DictRepository dictRepository, DictDetailRepository dictDetailRepository, DictDetailMapper dictDetailMapper, RedisUtils redisUtils) {
        this.dictRepository = dictRepository;
        this.dictDetailRepository = dictDetailRepository;
        this.dictDetailMapper = dictDetailMapper;
        this.redisUtils = redisUtils;
    }
}

