/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.security.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.modules.security.config.bean.SecurityProperties;
import me.zhengjie.modules.security.service.dto.JwtUserDto;
import me.zhengjie.modules.security.service.dto.OnlineUserDto;
import me.zhengjie.utils.EncryptUtils;
import me.zhengjie.utils.FileUtil;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.RedisUtils;
import me.zhengjie.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class OnlineUserService {
    private static final Logger log = LoggerFactory.getLogger(OnlineUserService.class);
    private final SecurityProperties properties;
    private final RedisUtils redisUtils;

    public OnlineUserService(SecurityProperties properties, RedisUtils redisUtils) {
        this.properties = properties;
        this.redisUtils = redisUtils;
    }

    public void save(JwtUserDto jwtUserDto, String token, HttpServletRequest request) {
        String dept = jwtUserDto.getUser().getDept().getName();
        String ip = StringUtils.getIp((HttpServletRequest)request);
        String browser = StringUtils.getBrowser((HttpServletRequest)request);
        String address = StringUtils.getCityInfo((String)ip);
        OnlineUserDto onlineUserDto = null;
        try {
            onlineUserDto = new OnlineUserDto(jwtUserDto.getUsername(), jwtUserDto.getUser().getNickName(), dept, browser, ip, address, EncryptUtils.desEncrypt((String)token), new Date());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.redisUtils.set(this.properties.getOnlineKey() + token, (Object)onlineUserDto, this.properties.getTokenValidityInSeconds() / 1000L);
    }

    public Map<String, Object> getAll(String filter, Pageable pageable) {
        List onlineUserDtos = this.getAll(filter);
        return PageUtil.toPage((Object)PageUtil.toPage((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (List)onlineUserDtos), (Object)onlineUserDtos.size());
    }

    public List<OnlineUserDto> getAll(String filter) {
        List keys = this.redisUtils.scan(this.properties.getOnlineKey() + "*");
        Collections.reverse(keys);
        ArrayList<OnlineUserDto> onlineUserDtos = new ArrayList<OnlineUserDto>();
        for (String key : keys) {
            OnlineUserDto onlineUserDto = (OnlineUserDto)this.redisUtils.get(key);
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                if (!onlineUserDto.toString().contains(filter)) continue;
                onlineUserDtos.add(onlineUserDto);
                continue;
            }
            onlineUserDtos.add(onlineUserDto);
        }
        onlineUserDtos.sort((o1, o2) -> o2.getLoginTime().compareTo(o1.getLoginTime()));
        return onlineUserDtos;
    }

    public void kickOut(String key) {
        key = this.properties.getOnlineKey() + key;
        this.redisUtils.del(new String[]{key});
    }

    public void logout(String token) {
        String key = this.properties.getOnlineKey() + token;
        this.redisUtils.del(new String[]{key});
    }

    public void download(List<OnlineUserDto> all, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (OnlineUserDto user : all) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u7528\u6237\u540d", user.getUserName());
            map.put("\u90e8\u95e8", user.getDept());
            map.put("\u767b\u5f55IP", user.getIp());
            map.put("\u767b\u5f55\u5730\u70b9", user.getAddress());
            map.put("\u6d4f\u89c8\u5668", user.getBrowser());
            map.put("\u767b\u5f55\u65e5\u671f", user.getLoginTime());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public OnlineUserDto getOne(String key) {
        return (OnlineUserDto)this.redisUtils.get(key);
    }

    public void checkLoginOnUser(String userName, String igoreToken) {
        List onlineUserDtos = this.getAll(userName);
        if (onlineUserDtos == null || onlineUserDtos.isEmpty()) {
            return;
        }
        for (OnlineUserDto onlineUserDto : onlineUserDtos) {
            if (!onlineUserDto.getUserName().equals(userName)) continue;
            try {
                String token = EncryptUtils.desDecrypt((String)onlineUserDto.getKey());
                if (StringUtils.isNotBlank((CharSequence)igoreToken) && !igoreToken.equals(token)) {
                    this.kickOut(token);
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)igoreToken)) continue;
                this.kickOut(token);
            }
            catch (Exception e) {
                log.error("checkUser is error", (Throwable)e);
            }
        }
    }

    @Async
    public void kickOutForUsername(String username) throws Exception {
        List onlineUsers = this.getAll(username);
        for (OnlineUserDto onlineUser : onlineUsers) {
            if (!onlineUser.getUserName().equals(username)) continue;
            String token = EncryptUtils.desDecrypt((String)onlineUser.getKey());
            this.kickOut(token);
        }
    }
}

