/*
 * Decompiled with CFR 0.152.
 */
package me.zhengjie.modules.system.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import me.zhengjie.annotation.Log;
import me.zhengjie.base.BaseEntity;
import me.zhengjie.exception.BadRequestException;
import me.zhengjie.modules.system.domain.Job;
import me.zhengjie.modules.system.service.JobService;
import me.zhengjie.modules.system.service.dto.JobQueryCriteria;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7cfb\u7edf\uff1a\u5c97\u4f4d\u7ba1\u7406"})
@RequestMapping(value={"/api/job"})
public class JobController {
    private final JobService jobService;
    private static final String ENTITY_NAME = "job";

    @ApiOperation(value="\u5bfc\u51fa\u5c97\u4f4d\u6570\u636e")
    @GetMapping(value={"/download"})
    @PreAuthorize(value="@el.check('job:list')")
    public void exportJob(HttpServletResponse response, JobQueryCriteria criteria) throws IOException {
        this.jobService.download(this.jobService.queryAll(criteria), response);
    }

    @ApiOperation(value="\u67e5\u8be2\u5c97\u4f4d")
    @GetMapping
    @PreAuthorize(value="@el.check('job:list','user:list')")
    public ResponseEntity<Object> queryJob(JobQueryCriteria criteria, Pageable pageable) {
        return new ResponseEntity((Object)this.jobService.queryAll(criteria, pageable), HttpStatus.OK);
    }

    @Log(value="\u65b0\u589e\u5c97\u4f4d")
    @ApiOperation(value="\u65b0\u589e\u5c97\u4f4d")
    @PostMapping
    @PreAuthorize(value="@el.check('job:add')")
    public ResponseEntity<Object> createJob(@Validated @RequestBody Job resources) {
        if (resources.getId() != null) {
            throw new BadRequestException("A new job cannot already have an ID");
        }
        this.jobService.create(resources);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Log(value="\u4fee\u6539\u5c97\u4f4d")
    @ApiOperation(value="\u4fee\u6539\u5c97\u4f4d")
    @PutMapping
    @PreAuthorize(value="@el.check('job:edit')")
    public ResponseEntity<Object> updateJob(@Validated(value={BaseEntity.Update.class}) @RequestBody Job resources) {
        this.jobService.update(resources);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Log(value="\u5220\u9664\u5c97\u4f4d")
    @ApiOperation(value="\u5220\u9664\u5c97\u4f4d")
    @DeleteMapping
    @PreAuthorize(value="@el.check('job:del')")
    public ResponseEntity<Object> deleteJob(@RequestBody Set<Long> ids) {
        this.jobService.verification(ids);
        this.jobService.delete(ids);
        return new ResponseEntity(HttpStatus.OK);
    }

    public JobController(JobService jobService) {
        this.jobService = jobService;
    }
}

